/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.molecules.instance;

import com.cudos.common.molecules.AbstractMoveable;
import com.cudos.common.molecules.AbstractMover;
import com.cudos.common.molecules.Collision;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Vector;

public class Phospholipid
extends AbstractMoveable {
    public double vx;
    public double vy;
    public double va;
    public static int r = 15;
    public static int waterlevel = -1;
    public static double repulsion = 0.0016;
    public static double repscale = 80.0;
    public static double attraction = 0.01;
    public static double attrscale = 400.0;
    public static double MI = 8.0;
    public boolean heldstill = false;
    static final int headr = 4;
    static final int width = 4;
    static final Shape[] shape = new Shape[7];
    static final Color brown = new Color(100, 24, 24);
    static final Color[] color = new Color[]{Color.green, brown, brown, brown, brown, Color.yellow, Color.yellow};
    Point2D absTailPos = new Point2D.Double(0.0, -r);
    Point2D absHeadPos = new Point2D.Double(0.0, r);
    double hfx;
    double hfy;
    double mfx;
    double mfy;
    double tfx;
    double tfy;
    final double fmin = -1.0;
    final double fmax = 1.0;

    static {
        Phospholipid.shape[0] = new Ellipse2D.Double(-4.0, -r, 8.0, 8.0);
        Phospholipid.shape[1] = new Rectangle(-1, -r + 8, 2, 2);
        Phospholipid.shape[2] = new Rectangle(-4, -r + 8 + 2, 8, 2);
        Phospholipid.shape[3] = new Rectangle(-4, -r + 8 + 4, 2, 2);
        Phospholipid.shape[4] = new Rectangle(2, -r + 8 + 4, 2, 2);
        int leg = 2 * r - 14;
        Phospholipid.shape[5] = new Rectangle(-4, -r + 8 + 6, 2, leg);
        Phospholipid.shape[6] = new Rectangle(2, -r + 8 + 6, 2, leg);
    }

    public void paint(Graphics g_) {
        Graphics2D g = (Graphics2D)g_;
        int i = 0;
        while (i < shape.length) {
            g.setColor(color[i]);
            Shape s = this.getTransform().createTransformedShape(shape[i]);
            g.fill(s);
            g.setColor(Color.black);
            g.draw(s);
            ++i;
        }
    }

    public Point2D getTailPos() {
        Point2D.Double q = new Point2D.Double();
        this.getTransform().transform(this.absTailPos, q);
        return q;
    }

    public Point2D getHeadPos() {
        Point2D.Double q = new Point2D.Double();
        this.getTransform().transform(this.absHeadPos, q);
        return q;
    }

    public Point2D calcAttraction(Point2D r) {
        double dsq = r.distanceSq(0.0, 0.0) / attrscale;
        double magnitude = Math.exp(-dsq / 3.0) - 3.0 * Math.exp(-dsq);
        double co = attraction * magnitude / Math.sqrt(dsq);
        if (dsq == 0.0) {
            co = 0.0;
        }
        return new Point2D.Double(co * r.getX(), co * r.getY());
    }

    public Point2D calcRepulsion(Point2D r) {
        double dsq = r.distanceSq(0.0, 0.0) / repscale;
        double magnitude = Math.exp(-dsq / repscale);
        double co = repulsion * magnitude / Math.sqrt(dsq);
        if (dsq == 0.0) {
            co = 0.0;
        }
        return new Point2D.Double(-co * r.getX(), -co * r.getY());
    }

    public void move(AbstractMover mover) {
        Point2D headp = this.getHeadPos();
        Point2D tailp = this.getTailPos();
        Vector mv = mover.mols();
        int i = mv.indexOf(this) + 1;
        while (i < mv.size()) {
            Phospholipid m = (Phospholipid)mv.get(i);
            if (m != this) {
                Point2D p = Collision.sub(m.getTailPos(), tailp);
                Point2D f = this.calcAttraction(p);
                p = Collision.sub(m.getPos(), this.getPos());
                f = this.calcAttraction(p);
                this.mfx += f.getX();
                m.mfx -= f.getX();
                this.mfy += f.getY();
                m.mfy -= f.getY();
                p = Collision.sub(m.getTailPos(), headp);
                f = this.calcRepulsion(p);
                this.hfx += f.getX();
                m.tfx -= f.getX();
                this.hfy += f.getY();
                m.tfy -= f.getY();
                p = Collision.sub(m.getHeadPos(), tailp);
                f = this.calcRepulsion(p);
                this.tfx += f.getX();
                m.hfx -= f.getX();
                this.tfy += f.getY();
                m.hfy -= f.getY();
            }
            ++i;
        }
        if (waterlevel > 0) {
            double d = this.getPos().getY() - (double)waterlevel - 20.0;
            double dsq = d * d / repscale;
            double magnitude = 2.0 * Math.exp(-dsq) - Math.exp(-dsq / 2.0);
            this.tfy += attraction * magnitude;
            d = headp.getY() - (double)waterlevel;
            dsq = d * d / repscale;
            magnitude = Math.exp(-dsq / 2.0);
        }
        this.hfx = Math.max(Math.min(this.hfx, 1.0), -1.0);
        this.hfy = Math.max(Math.min(this.hfy, 1.0), -1.0);
        this.mfx = Math.max(Math.min(this.mfx, 1.0), -1.0);
        this.mfy = Math.max(Math.min(this.mfy, 1.0), -1.0);
        this.tfx = Math.max(Math.min(this.tfx, 1.0), -1.0);
        this.tfy = Math.max(Math.min(this.tfy, 1.0), -1.0);
        this.vx += this.hfx + this.mfx + this.tfx;
        this.vy += this.hfy + this.mfy + this.tfy;
        double dfx = this.hfx - this.tfx;
        double dfy = this.hfy - this.tfy;
        this.va += Collision.cross(Collision.sub(this.getPos(), headp), new Point2D.Double(dfx, dfy)) / MI;
        this.va *= 0.95;
        this.vx *= 0.99;
        this.vy *= 0.99;
        this.tfy = 0.0;
        this.tfx = 0.0;
        this.mfy = 0.0;
        this.mfx = 0.0;
        this.hfy = 0.0;
        this.hfx = 0.0;
        if (!this.heldstill) {
            Point2D.Double np = new Point2D.Double(this.getPos().getX() + this.vx, this.getPos().getY() + this.vy);
            if (((Point2D)np).getX() < 0.0 || ((Point2D)np).getX() > (double)mover.getWidth()) {
                this.vx = -this.vx;
            }
            if (((Point2D)np).getY() < 0.0 || ((Point2D)np).getY() > (double)mover.getHeight()) {
                this.vy = -this.vy;
            }
            if (((Point2D)np).getY() < (double)waterlevel) {
                ((Point2D)np).setLocation(((Point2D)np).getX(), waterlevel);
                this.vy = 0.0;
            }
            this.setPos(np);
        }
        this.setOrientation(this.getOrientation() + this.va);
    }

    public double erf(double x) {
        double xp = x;
        double xsq = x * x;
        double t = x;
        int n = 1;
        int fac = 1;
        while (n++ < (int)x + 2) {
            t += (xp *= xsq) * (double)(n % 2 == 0 ? -1 : 1) / (double)((n - 1) * 2 + 1) / (double)(fac *= n);
        }
        return t;
    }
}

