/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.molecules;

import com.cudos.common.molecules.AbstractMolecule;
import java.awt.geom.Rectangle2D;

public abstract class RectangularMolecule
extends AbstractMolecule {
    double width;
    double height;

    protected boolean isMoveable() {
        return false;
    }

    public Rectangle2D getRectangle() {
        return new Rectangle2D.Double(-this.width / 2.0, -this.height / 2.0, this.width, this.height);
    }

    public Rectangle2D getRectangleAbsolute() {
        double tx = this.getTransform().getTranslateX();
        double ty = this.getTransform().getTranslateY();
        Rectangle2D r = this.getRectangle();
        r.setRect(r.getX() + tx, r.getY() + ty, r.getWidth(), r.getHeight());
        return r;
    }

    public boolean intersects(AbstractMolecule a) {
        if (a instanceof RectangularMolecule) {
            return this.getRectangleAbsolute().intersects(((RectangularMolecule)a).getRectangleAbsolute());
        }
        return a.intersects(this);
    }
}

