/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.molecules;

import com.cudos.common.molecules.AbstractMolecule;
import com.cudos.common.molecules.CircularMolecule;
import com.cudos.common.molecules.RectangularMolecule;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class PolygonMolecule
extends AbstractMolecule {
    protected Shape shape;

    boolean polygonsIntersect(Shape s1, Shape s2) {
        if (s1.getBounds().intersects(s2.getBounds())) {
            double[] p = new double[2];
            PathIterator pi = s1.getPathIterator(null);
            while (pi.isDone()) {
                pi.currentSegment(p);
                if (s2.contains(p[0], p[1])) {
                    return true;
                }
                pi.next();
            }
        }
        return false;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Shape getShapeAbsolute() {
        return this.getTransform().createTransformedShape(this.getShape().getBounds());
    }

    public boolean intersects(AbstractMolecule a) {
        if (a instanceof PolygonMolecule) {
            PolygonMolecule m = (PolygonMolecule)a;
            Shape me = this.getShapeAbsolute();
            Shape him = m.getShapeAbsolute();
            return this.polygonsIntersect(me, him);
        }
        if (a instanceof RectangularMolecule) {
            RectangularMolecule m = (RectangularMolecule)a;
            Rectangle2D r = m.getRectangleAbsolute();
            Shape me = this.getShapeAbsolute();
            if (me.getBounds().intersects(r)) {
                double[] p = new double[2];
                PathIterator pi = me.getPathIterator(null);
                while (pi.isDone()) {
                    pi.currentSegment(p);
                    if (r.contains(p[0], p[1])) {
                        return true;
                    }
                    pi.next();
                }
            }
            return false;
        }
        if (a instanceof CircularMolecule) {
            CircularMolecule m = (CircularMolecule)a;
            double r = m.getRadius();
            Point2D pos = m.getPos();
            Shape me = this.getShapeAbsolute();
            if (me.getBounds().intersects(m.getShapeAbsolute().getBounds())) {
                double[] p = new double[2];
                PathIterator pi = me.getPathIterator(null);
                while (pi.isDone()) {
                    pi.currentSegment(p);
                    if (pos.distance(p[0], p[1]) < r) {
                        return true;
                    }
                    pi.next();
                }
            }
            return false;
        }
        return a.intersects(this);
    }
}

