/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.molecules;

import com.cudos.common.molecules.AbstractMolecule;
import com.cudos.common.molecules.AbstractWall;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.swing.JPanel;

public class MoleculePane
extends JPanel {
    protected Vector molecules = new Vector();
    protected Vector walls = new Vector();
    protected Random rand = new Random();

    public void addMolecule(String cls) {
        this.addMolecule(cls, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public void addMolecule(String cls, Rectangle rect) {
        Point2D.Double pos;
        int tries = 0;
        boolean collide = false;
        Point size = new Point(10, 10);
        do {
            pos = new Point2D.Double((double)rect.x + (double)rect.width * this.rand.nextDouble(), (double)rect.y + (double)rect.height * this.rand.nextDouble());
            Enumeration e = this.walls.elements();
            while (e.hasMoreElements()) {
                AbstractWall test = (AbstractWall)e.nextElement();
                if (!test.intersectTest(pos, size)) continue;
                collide = true;
            }
        } while (collide && tries++ < 20);
        double angle = this.rand.nextDouble() * Math.PI * 2.0;
        double speed = this.rand.nextDouble() * 5.0;
        Point2D.Double vel = new Point2D.Double(speed * Math.cos(angle), speed * Math.sin(angle));
        try {
            Class<?> p2d = Class.forName("java.awt.geom.Point2D");
            Class[] paramcls = new Class[]{p2d, p2d, this.getClass()};
            AbstractMolecule m = (AbstractMolecule)Class.forName("com.cudos.common.molecules." + cls).getConstructor(paramcls).newInstance(pos, vel, this);
            this.molecules.add(m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void nextFrame() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        Enumeration e = this.molecules.elements();
        while (e.hasMoreElements()) {
            Point2D np;
            AbstractMolecule m = (AbstractMolecule)e.nextElement();
            if (m.attachedTo != null) {
                np = m.attachedTo.requestLigandMove(m);
            } else {
                np = m.requestMove();
                Enumeration f = this.walls.elements();
                while (f.hasMoreElements()) {
                    AbstractWall w = (AbstractWall)f.nextElement();
                    np = w.collisionFunction(np, m);
                }
            }
            m.paint(g, false);
            m.p = np;
            m.paint(g, true);
        }
    }
}

