/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.molecules;

import com.cudos.common.molecules.AbstractMolecule;
import com.cudos.common.molecules.AbstractMoveable;
import com.cudos.common.molecules.AbstractMover;
import com.cudos.common.molecules.Collision;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.Enumeration;

public class MoleculeMover
extends AbstractMover {
    Collision getCollision(AbstractMoveable mov, Point2D np) {
        AbstractMolecule m = (AbstractMolecule)mov;
        if (!this.getBounds().contains(np)) {
            double x = np.getX();
            if (x < this.getBounds().getX()) {
                return new Collision(m, new Point2D.Double(1.0, 0.0));
            }
            if (x > this.getBounds().getX() + this.getBounds().getWidth()) {
                return new Collision(m, new Point2D.Double(-1.0, 0.0));
            }
            double y = np.getY();
            if (y < this.getBounds().getY()) {
                return new Collision(m, new Point2D.Double(0.0, 1.0));
            }
            if (y > this.getBounds().getY() + this.getBounds().getHeight()) {
                return new Collision(m, new Point2D.Double(0.0, -1.0));
            }
        }
        Point2D op = m.getPos();
        m.setPos(np);
        Enumeration e = this.molecules.elements();
        while (e.hasMoreElements()) {
            AbstractMolecule mm = (AbstractMolecule)e.nextElement();
            if (m == mm || !m.intersects(mm)) continue;
            m.setPos(op);
            return new Collision(m, mm);
        }
        return null;
    }

    void paintBackgroundElements(Graphics g) {
    }
}

