/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.molecules;

import com.cudos.common.molecules.AbstractMolecule;
import com.cudos.common.molecules.ActiveSite;
import com.cudos.common.molecules.CircularMolecule;
import com.cudos.common.molecules.RectangularMolecule;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Collision {
    AbstractMolecule m1;
    AbstractMolecule m2;
    boolean binding;

    public Collision(AbstractMolecule a1, AbstractMolecule a2) {
        this.m1 = a1;
        this.m2 = a2;
        this.binding = false;
        int i = 0;
        while (i < this.m1.activeSite.length) {
            int j = 0;
            while (j < this.m2.activeSite.length) {
                if (this.m1.activeSite[i].intersects(this.m2.activeSite[j])) {
                    this.tryBinding(this.m1.activeSite[i], this.m2.activeSite[j]);
                    if (this.binding) break;
                }
                ++j;
            }
            if (this.binding) break;
            ++i;
        }
        if (this.binding) {
            if (this.m1.boundTo == this.m2) {
                this.bindingMomentum(this.m2, this.m1);
            } else {
                this.bindingMomentum(this.m1, this.m2);
            }
        } else {
            this.bounce(a1, a2);
        }
    }

    void tryBinding(ActiveSite a1, ActiveSite a2) {
        if (a1.canBind(this.m2) && a2.canBind(this.m1)) {
            a1.bind(a2);
            a2.bind(a1);
            this.binding = true;
        }
    }

    public Collision(AbstractMolecule a, Point2D normal) {
        this.m1 = a;
        this.m2 = null;
        this.binding = false;
        this.bounceUnmoveable(a, normal);
    }

    Point2D direction(Point2D p1, Point2D p2) {
        return new Point2D.Double(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    Point2D getNormalToRectangle(Rectangle2D r, Point2D p, double d) {
        if (p.getX() + d > r.getX() && p.getX() - d < r.getX() + r.getWidth()) {
            if (p.getY() > r.getY() + r.getWidth()) {
                return new Point2D.Double(0.0, 1.0);
            }
            if (p.getY() < r.getY()) {
                return new Point2D.Double(0.0, -1.0);
            }
        } else if (p.getY() + d > r.getY() && p.getY() - d < r.getY() + r.getHeight()) {
            if (p.getX() > r.getX() + r.getWidth()) {
                return new Point2D.Double(1.0, 0.0);
            }
            if (p.getX() < r.getX()) {
                return new Point2D.Double(-1.0, 0.0);
            }
        }
        return this.direction(this.getRectangleCentre(r), p);
    }

    Point2D getRectangleCentre(Rectangle2D r) {
        return new Point2D.Double(r.getX() + r.getWidth() / 2.0, r.getY() + r.getHeight() / 2.0);
    }

    void bounce(AbstractMolecule a1, AbstractMolecule a2) {
        if (a1.isMoveable() && a2.isMoveable()) {
            if (a1 instanceof CircularMolecule) {
                CircularMolecule c1 = (CircularMolecule)a1;
                if (a2 instanceof CircularMolecule) {
                    this.bounceCircleCircle(c1, (CircularMolecule)a2);
                } else if (a2 instanceof RectangularMolecule) {
                    this.bounceCircleRectangle(c1, (RectangularMolecule)a2);
                }
            } else if (a1 instanceof RectangularMolecule) {
                RectangularMolecule r1 = (RectangularMolecule)a1;
                if (a2 instanceof CircularMolecule) {
                    this.bounceCircleRectangle((CircularMolecule)a2, r1);
                } else if (a2 instanceof RectangularMolecule) {
                    this.bounceRectangleRectangle(r1, (RectangularMolecule)a2);
                }
            }
        } else {
            if (!a1.isMoveable()) {
                AbstractMolecule t = a1;
                a1 = a2;
                a2 = t;
            }
            if (a1 instanceof CircularMolecule) {
                CircularMolecule c1 = (CircularMolecule)a1;
                if (a2 instanceof CircularMolecule) {
                    this.bounceCircle(c1, this.direction(a1.getPos(), a2.getPos()));
                } else if (a2 instanceof RectangularMolecule) {
                    this.bounceCircle(c1, this.getNormalToRectangle(((RectangularMolecule)a1).getRectangleAbsolute(), c1.getPos(), c1.getRadius()));
                }
            }
        }
    }

    void bounceCircle(CircularMolecule m, Point2D normal) {
        Point2D v1 = m.getVel();
        double v = v1.distance(0.0, 0.0);
        double thn = Math.atan2(normal.getY(), normal.getX());
        double th1 = Math.atan2(v1.getY(), v1.getX());
        double th2 = 2.0 * thn - th1;
        m.setVel(new Point2D.Double(v * Math.cos(th2), v * Math.sin(th2)));
    }

    void bounceCircleCircle(CircularMolecule m1, CircularMolecule m2) {
        double dx = m2.getPos().getX() - m1.getPos().getX();
        double dy = m2.getPos().getY() - m1.getPos().getY();
        Point2D p = Collision.sub(m2.getPos(), m1.getPos());
        Point2D v = Collision.unit(m1.getVel());
        double rr = m1.getRadius() + m2.getRadius();
        double j = Collision.dot(p, Collision.perp(v));
        double lambda = -Collision.dot(p, v) + Math.sqrt(rr * rr - j * j);
        Point2D dvector = Collision.mult(v, lambda);
        m1.setPos(Collision.sub(m1.getPos(), dvector));
        double vx = m1.getVel().getX();
        double vy = m1.getVel().getY();
        double Vx = m2.getVel().getX();
        double Vy = m2.getVel().getY();
        double mass = m1.getMass();
        double Mass = m2.getMass();
        double al = Math.atan2(dy, dx);
        double th1 = Math.atan2(vy, vx) - al;
        double ph1 = Math.atan2(Vy, Vx) - al;
        double v1 = m1.vel.distance(0.0, 0.0);
        double V1 = m2.vel.distance(0.0, 0.0);
        double th2 = Math.atan2(v1 * Math.sin(th1) * (mass + Mass), (mass - Mass) * v1 * Math.cos(th1) + 2.0 * Mass * V1 * Math.cos(ph1));
        double ph2 = Math.atan2(V1 * Math.sin(ph1) * (Mass + mass), 2.0 * mass * v1 * Math.cos(th1) + (Mass - mass) * V1 * Math.cos(ph1));
        double V2 = Math.sqrt(Math.pow((2.0 * mass * v1 * Math.cos(th1) + (Mass - mass) * V1 * Math.cos(ph1)) / (mass + Mass), 2.0) + V1 * V1 * Math.sin(ph1) * Math.sin(ph1));
        double v2 = Math.sqrt(Math.pow(((mass - Mass) * v1 * Math.cos(th1) + 2.0 * Mass * V1 * Math.cos(ph1)) / (mass + Mass), 2.0) + v1 * v1 * Math.sin(th1) * Math.sin(th1));
        m1.setVel(new Point2D.Double(v2 * Math.cos(th2 + al), v2 * Math.sin(th2 + al)));
        m2.setVel(new Point2D.Double(V2 * Math.cos(ph2 + al), V2 * Math.sin(ph2 + al)));
    }

    void bounceCircleRectangle(CircularMolecule m1, RectangularMolecule m2) {
    }

    void bounceRectangleRectangle(RectangularMolecule m1, RectangularMolecule m2) {
    }

    void bindingMomentum(AbstractMolecule m1, AbstractMolecule m2) {
        double mass2 = m2.getTotalMass();
        double mass3 = m1.getTotalMass();
        double mass1 = mass3 - mass2;
        m1.setVel(new Point2D.Double((mass1 * m1.getVel().getX() + mass2 * m2.getVel().getX()) / mass3, (mass1 * m1.getVel().getY() + mass2 * m2.getVel().getY()) / mass3));
    }

    void bounceUnmoveable(AbstractMolecule a, Point2D normal) {
        double perpm = Collision.dot(a.getVel(), normal);
        Point2D perp = Collision.mult(normal, perpm);
        Point2D para = Collision.sub(a.getVel(), perp);
        if (perpm > 0.0) {
            perp = Collision.mult(perp, -1.0);
        }
        a.setVel(Collision.sub(para, perp));
    }

    public static double dot(Point2D a, Point2D b) {
        return a.getX() * b.getX() + a.getY() * b.getY();
    }

    public static double modsq(Point2D a) {
        return a.getX() * a.getX() + a.getY() * a.getY();
    }

    public static Point2D perp(Point2D a) {
        return new Point2D.Double(a.getY(), -a.getX());
    }

    public static Point2D add(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static Point2D sub(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public static Point2D mult(Point2D p, double c) {
        return new Point2D.Double(p.getX() * c, p.getY() * c);
    }

    public static Point2D unit(Point2D p) {
        double m = Collision.modsq(p);
        return new Point2D.Double(p.getX() / m, p.getY() / Math.sqrt(m));
    }

    public static double cross(Point2D a, Point2D b) {
        return a.getX() * b.getY() - a.getY() * b.getX();
    }
}

