/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.molecules;

import com.cudos.common.molecules.AbstractMolecule;
import com.cudos.common.molecules.RectangularMolecule;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public abstract class CircularMolecule
extends AbstractMolecule {
    protected double radius;

    double getRadius() {
        return this.radius;
    }

    Shape getShape() {
        return new Ellipse2D.Double(-this.radius, -this.radius, 2.0 * this.radius, 2.0 * this.radius);
    }

    Shape getShapeAbsolute() {
        return new Ellipse2D.Double(this.getPos().getX() - this.radius, this.getPos().getY() - this.radius, 2.0 * this.radius, 2.0 * this.radius);
    }

    boolean inCircle(double x, double y) {
        return this.getPos().distance(x, y) < this.getRadius();
    }

    public boolean intersects(AbstractMolecule a) {
        if (a instanceof RectangularMolecule) {
            Rectangle2D r = ((RectangularMolecule)a).getRectangleAbsolute();
            if (this.inCircle(r.getX(), r.getY())) {
                return true;
            }
            if (this.inCircle(r.getX(), r.getY() + r.getHeight())) {
                return true;
            }
            if (this.inCircle(r.getX() + r.getWidth(), r.getY())) {
                return true;
            }
            return this.inCircle(r.getX() + r.getWidth(), r.getY() + r.getHeight());
        }
        if (a instanceof CircularMolecule) {
            return this.getPos().distance(a.getPos()) < this.getRadius() + ((CircularMolecule)a).getRadius();
        }
        return a.intersects(this);
    }

    public void paint(Graphics2D g, boolean b) {
        g.fillOval((int)(this.getPos().getX() - this.radius), (int)(this.getPos().getY() - this.radius), (int)(this.radius * 2.0), (int)(this.radius * 2.0));
    }
}

