/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.molecules;

import com.cudos.common.molecules.AbstractMolecule;
import com.cudos.common.molecules.AbstractMoveable;
import com.cudos.common.molecules.AbstractMover;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;

public class ActiveSite
extends AbstractMoveable {
    AbstractMolecule owner;
    ActiveSite boundTo;
    Class[] canBind;
    double radius;

    public void setup(AbstractMolecule owner, double distance, double angle, double radius, String[] bindable) {
        this.owner = owner;
        this.radius = radius;
        this.setPos(new Point2D.Double(distance * Math.sin(angle), distance * Math.cos(angle)));
        this.setOrientation(angle);
        this.canBind = new Class[bindable.length];
        int i = 0;
        while (i < this.canBind.length) {
            try {
                this.canBind[i] = Class.forName("com.cudos.common.molecules.instance." + bindable[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public boolean canBind(AbstractMolecule m) {
        if (this.boundTo != null) {
            return false;
        }
        int i = 0;
        while (i < this.canBind.length) {
            if (m.getClass() == this.canBind[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean intersects(ActiveSite a) {
        return this.absolutePosition().distance(a.absolutePosition()) < this.radius + a.radius;
    }

    public void bind(ActiveSite a) {
        this.boundTo = a;
        if (this.owner.getMass() < a.owner.getMass()) {
            this.owner.boundBy = this;
            this.owner.boundTo = a.owner;
        }
    }

    public Point2D absolutePosition() {
        return this.owner.getTransform().transform(this.getTransform().transform(new Point(0, 0), null), null);
    }

    public double absoluteOrientation() {
        return this.owner.getOrientation() + this.orientation;
    }

    public void move(AbstractMover m) {
    }

    public void paint(Graphics g) {
    }
}

