/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.molecules;

import com.cudos.common.molecules.AbstractMover;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public abstract class AbstractMoveable {
    protected Point2D rPos = new Point2D.Double(0.0, 0.0);
    protected double orientation = 0.0;
    protected AffineTransform transform;

    void updateTransform() {
        this.transform = new AffineTransform(Math.cos(this.getOrientation()), -Math.sin(this.getOrientation()), Math.sin(this.getOrientation()), Math.cos(this.getOrientation()), this.getPos().getX(), this.getPos().getY());
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Point2D getPos() {
        return this.rPos;
    }

    public synchronized void setPos(Point2D p) {
        this.rPos = p;
        this.updateTransform();
    }

    public double getOrientation() {
        return this.orientation;
    }

    public synchronized void setOrientation(double o) {
        this.orientation = o;
        this.updateTransform();
    }

    public AbstractMoveable() {
        this.updateTransform();
    }

    public abstract void paint(Graphics var1);

    public abstract void move(AbstractMover var1);
}

