/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.molecules;

import com.cudos.common.CudosApplet;
import com.cudos.common.molecules.AbstractMoveable;
import com.cudos.common.molecules.AbstractMover;
import com.cudos.common.molecules.ActiveSite;
import com.cudos.common.molecules.Collision;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public abstract class AbstractMolecule
extends AbstractMoveable {
    public ActiveSite[] activeSite = new ActiveSite[0];
    ActiveSite boundBy = null;
    AbstractMolecule boundTo = null;
    Point2D vel = new Point2D.Double(10.0 * Math.random(), 10.0 * Math.random());
    double angvel = 0.1;
    public static CudosApplet applet;
    private Image image;
    private int iw;
    private int ih;
    public AbstractMolecule attachedTo;
    public Point2D p;

    protected abstract boolean isMoveable();

    protected abstract double getMass();

    abstract boolean intersects(AbstractMolecule var1);

    protected abstract String getImageName();

    public AbstractMolecule() {
        this.setPos(new Point2D.Double(Math.random(), Math.random()));
        this.image = applet.getImage(this.getImageName());
        this.iw = this.image.getWidth(null);
        this.ih = this.image.getHeight(null);
    }

    public void move(AbstractMover mover) {
        if (!this.isMoveable()) {
            return;
        }
        if (this.boundTo != null) {
            Point2D p1 = this.boundBy.boundTo.absolutePosition();
            Point2D p2 = null;
            this.setOrientation(1.5707963267948966 + this.boundBy.boundTo.absoluteOrientation() - this.boundBy.getOrientation());
            try {
                p2 = this.boundBy.getTransform().inverseTransform(new Point(0, 0), null);
                p2 = this.getTransform().createInverse().deltaTransform(p2, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setPos(new Point2D.Double(p1.getX() + p2.getX(), p1.getY() + p2.getY()));
        } else {
            Point2D.Double nPos = new Point2D.Double(this.getPos().getX() + this.vel.getX(), this.getPos().getY() + this.vel.getY());
            double nOrientation = this.getOrientation() + this.angvel;
            Collision c = mover.getCollision(this, nPos);
            if (c != null) {
                nPos = new Point2D.Double(this.getPos().getX() + this.vel.getX(), this.getPos().getY() + this.vel.getY());
                nOrientation = this.getOrientation() + this.angvel;
                this.setPos(nPos);
                this.setOrientation(nOrientation);
            } else {
                this.setPos(nPos);
                this.setOrientation(nOrientation);
            }
        }
    }

    double getBoundMass() {
        double tot = this.getMass();
        int i = 0;
        while (i < this.activeSite.length) {
            if (this.activeSite[i].boundTo != null) {
                AbstractMolecule m = this.activeSite[i].boundTo.owner;
                if (m.boundTo != null && m.boundTo == this) {
                    tot += m.getBoundMass();
                }
            }
            ++i;
        }
        return tot;
    }

    public double getTotalMass() {
        if (this.boundTo == null) {
            return this.getBoundMass();
        }
        return this.boundTo.getTotalMass();
    }

    public void setVel(Point2D v) {
        if (this.boundTo == null) {
            this.vel.setLocation(v);
        } else {
            this.boundTo.setVel(v);
        }
    }

    public Point2D getVel() {
        if (this.boundTo == null) {
            return this.vel;
        }
        return this.boundTo.getVel();
    }

    private Point getDrawingPosition() {
        Point2D p = this.getPos();
        this.getTransform().translate(p.getX(), p.getY());
        return new Point((int)p.getX(), (int)p.getY());
    }

    AffineTransform getImageTransform() {
        AffineTransform a = (AffineTransform)this.getTransform().clone();
        a.translate(-this.iw / 2, -this.ih / 2);
        return a;
    }

    public void paint(Graphics g_) {
        Graphics2D g = (Graphics2D)g_;
        g.drawImage(this.image, this.getImageTransform(), null);
    }

    public Point2D requestLigandMove(AbstractMolecule m) {
        return null;
    }

    public Point2D requestMove() {
        return null;
    }

    public abstract void paint(Graphics2D var1, boolean var2);
}

