/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.kinetic;

import com.cudos.common.kinetic.Membrane;
import com.cudos.common.kinetic.MembraneTransporter;
import com.cudos.common.kinetic.Molecule;
import java.awt.Color;
import java.awt.Graphics2D;

public class SodiumPump
extends MembraneTransporter {
    int numNBound = 0;
    int numKBound = 0;
    Molecule[] na = new Molecule[3];
    Molecule[] k = new Molecule[2];
    int frame = 0;
    int frames = 7;
    boolean transporting = false;
    Color molbg;
    Color pumpColor = new Color(128, 192, 128);

    public boolean initTransport(Molecule m) {
        if (!this.transporting && m.getType() == 2 && this.transportDirectionY > 0 && this.numNBound < 3) {
            this.na[this.numNBound] = m;
            m.y = this.y - this.s;
            m.x = this.x - this.s + (this.numNBound + 1) * this.s / 2 - m.s / 2;
            this.molbg = m.bg;
            m.bg = this.pumpColor;
            if (++this.numNBound == 3 && this.numKBound == 2) {
                this.transporting = true;
                this.frame = this.frames;
            }
            return true;
        }
        if (!this.transporting && m.getType() == 3 && this.transportDirectionY < 0 && this.numKBound < 2) {
            this.k[this.numKBound] = m;
            m.y = this.y + this.s - m.s;
            m.x = this.x - this.s + (this.numKBound + 1) * 2 * this.s / 3 - m.s / 2;
            this.molbg = m.bg;
            m.bg = this.pumpColor;
            if (++this.numKBound == 2 && this.numNBound == 3) {
                this.transporting = true;
                this.frame = this.frames;
            }
            return true;
        }
        return false;
    }

    public void postInitTransport() {
        if (!this.transporting) {
            this.bound = false;
            this.ligand = null;
        }
    }

    public boolean continueTransport(Molecule m) {
        if (this.transporting) {
            if (m.getType() == 2) {
                m.y += 3 * this.s / this.frames;
                if (m.y >= this.y + this.s) {
                    m.bg = this.molbg;
                }
            } else if (m.getType() == 3) {
                m.y -= 3 * this.s / this.frames;
                if (m.y <= this.y - this.s - m.s) {
                    m.bg = this.molbg;
                }
            }
            if (m == this.na[0]) {
                --this.frame;
            }
            if (this.frame <= 0) {
                int d;
                int n = d = m.getType() == 2 ? 1 : -1;
                if (d == 1) {
                    --this.numNBound;
                } else {
                    --this.numKBound;
                }
                if (this.numNBound <= 0 && this.numKBound <= 0) {
                    this.numNBound = 0;
                    this.numKBound = 0;
                    this.transporting = false;
                }
                m.bg = this.molbg;
                m.y += d * m.s + 2;
                m.vy = d * Math.abs(m.vy);
                return false;
            }
        }
        return true;
    }

    public void paint(Graphics2D g, boolean u) {
        g.setColor(this.pumpColor);
        g.fillRoundRect(this.x - this.s, this.y - this.s, 2 * this.s, 2 * this.s, 4, 4);
    }

    public SodiumPump(Membrane m, int a, int w) {
        super(m, a, w);
    }
}

