/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.kinetic;

import com.cudos.common.kinetic.Membrane;
import com.cudos.common.kinetic.MembraneTransporter;
import com.cudos.common.kinetic.Molecule;
import java.awt.Color;
import java.awt.Graphics2D;

public class SimplePump
extends MembraneTransporter {
    int animframe = 0;
    int frames = 10;
    Color molprevbg;

    public SimplePump(Membrane mem, int along, int w) {
        super(mem, along, w);
        this.activeType = 1;
    }

    public boolean initTransport(Molecule m) {
        if (m.getType() == this.activeType && this.transportDirectionY > 0) {
            this.animframe = this.frames;
            m.x = this.x;
            m.y = this.y - this.s;
            this.molprevbg = m.bg;
            m.bg = cols[this.getType()];
            return true;
        }
        return false;
    }

    public boolean continueTransport(Molecule m) {
        int dx = (int)((double)(this.s - m.s / 2) * Math.sin((double)this.animframe * Math.PI / (double)this.frames));
        int dy = (int)((double)(this.s - m.s / 2) * Math.cos((double)this.animframe * Math.PI / (double)this.frames));
        m.x = this.x - m.s / 2 + dx;
        m.y = this.y - m.s / 2 + dy;
        if (this.animframe-- <= 0) {
            m.bg = this.molprevbg;
            return false;
        }
        return true;
    }

    public void paint(Graphics2D g, boolean u) {
        super.paint(g, u);
        if (this.animframe > 0) {
            int dx = (int)((double)this.s * Math.sin((double)this.animframe * Math.PI / (double)this.frames));
            int dy = (int)((double)this.s * Math.cos((double)this.animframe * Math.PI / (double)this.frames));
            g.setColor(Color.black);
            g.drawLine(this.x, this.y, this.x + dx, this.y + dy);
        }
    }
}

