/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.kinetic;

import com.cudos.common.PaintableComponent;
import com.cudos.common.kinetic.Ligand;
import com.cudos.common.kinetic.MassiveMolecule;
import com.cudos.common.kinetic.MoleculeListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Random;

public class Molecule
implements PaintableComponent,
Ligand,
MoleculeListener {
    public static final int WATER = 0;
    public static final int SUGAR = 1;
    public static final int SODIUM = 2;
    public static final int POTASSIUM = 3;
    public static final int MEMBRANE_PROTEIN = 4;
    public static final int PROTEIN = 5;
    public static final int CELL = 6;
    public static final String[] names = new String[]{"Water", "Sugar", "Sodium", "Potassium", "Membrane Protein", "Protein", "Cell"};
    public static final Color[] cols = new Color[]{Color.blue, Color.magenta, Color.red, Color.blue, Color.orange, Color.gray, Color.white};
    public static final int[] defsize = new int[]{2, 8, 6, 6, 7, 7, 15};
    public static final boolean[] hydrs;
    public Color bg = new Color(192, 224, 224);
    public int x;
    public int y;
    public int vx;
    public int vy;
    public int s = 2;
    private int type = 0;
    protected Molecule ligand = null;
    boolean bound = false;
    protected boolean waterBinding = false;
    public Polygon shape = null;
    Random rand = new Random();
    MoleculeListener listener = null;

    static {
        boolean[] blArray = new boolean[7];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        hydrs = blArray;
    }

    public Molecule getLigand() {
        return this.ligand;
    }

    public void setLigand(Molecule l) {
        this.ligand = l;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean b) {
        if (this.bound && b) {
            throw new RuntimeException("Ligand already bound!");
        }
        this.bound = b;
    }

    public boolean isWaterBinding() {
        return this.waterBinding;
    }

    public void setWaterBinding(boolean b) {
        this.waterBinding = b;
    }

    public Molecule() {
        this(10, 10);
    }

    public Molecule(int nx, int ny) {
        this(nx, ny, 1, 1);
    }

    public Molecule(int nx, int ny, int nvx, int nvy) {
        this.x = nx;
        this.y = ny;
        this.vx = nvx;
        this.vy = nvy;
    }

    public Molecule(Random r, Rectangle b) {
        this.x = r.nextInt((int)b.getWidth()) + (int)b.getX();
        this.y = r.nextInt((int)b.getHeight()) + (int)b.getY();
        this.vx = r.nextInt(30 / this.s) - 15 / this.s;
        this.vy = r.nextInt(30 / this.s) - 15 / this.s;
        if (this.vx == 0) {
            ++this.vx;
        }
        if (this.vy == 0) {
            ++this.vy;
        }
    }

    public void setType(int t) {
        this.type = t;
        this.s = defsize[this.type];
        this.waterBinding = hydrs[this.type];
        if (this.type == 3) {
            int[] nArray = new int[3];
            nArray[1] = this.s;
            nArray[2] = this.s / 2;
            int[] nArray2 = new int[3];
            nArray2[2] = this.s;
            this.shape = new Polygon(nArray, nArray2, 3);
        }
    }

    public int getType() {
        return this.type;
    }

    public void paint(Graphics2D g, boolean draw) {
        if (draw) {
            g.setColor(cols[this.type]);
        } else {
            g.setColor(this.bg);
        }
        switch (this.type) {
            case 0: {
                g.fillRect(this.x, this.y, this.s, this.s);
                break;
            }
            case 1: {
                g.fillRect(this.x, this.y, this.s, this.s);
                break;
            }
            case 2: {
                g.fillOval(this.x, this.y, this.s, this.s);
                break;
            }
            case 3: {
                this.shape.translate(this.x, this.y);
                g.fill(this.shape);
                this.shape.translate(-this.x, -this.y);
                break;
            }
            case 5: {
                g.fillOval(this.x, this.y, this.s, this.s);
            }
        }
    }

    public void move(Graphics2D g, int nx, int ny) {
        if (this.bound && this.ligand.getType() == 4) {
            return;
        }
        this.paint(g, false);
        this.x = nx;
        this.y = ny;
        this.paint(g, true);
        if (this.ligand != null) {
            this.unbind();
        }
    }

    public void unbind() {
        if (this.bound && this.ligand.getType() == 4) {
            return;
        }
        if (this.bound && this.ligand.getLigand() == this) {
            this.ligand.setLigand(null);
            this.ligand.setBound(false);
            if (this.ligand.getMoleculeListener() == this) {
                this.ligand.setMoleculeListener(null);
            }
            if (this.listener != null) {
                this.listener = null;
            }
            this.bound = false;
            this.ligand = null;
        }
    }

    public boolean moleculeEvent(Molecule m) {
        if (m instanceof MassiveMolecule && this instanceof MassiveMolecule) {
            MassiveMolecule mol = (MassiveMolecule)m;
            MassiveMolecule Mol = (MassiveMolecule)this;
            mol.x = Mol.x - (double)mol.s;
            mol.y = Mol.y;
        } else {
            m.x = this.x - m.s;
            m.y = this.y;
        }
        if (this.rand.nextInt(200) == 0) {
            m.setMoleculeListener(null);
            m.setBound(false);
            m.setLigand(null);
            this.bound = false;
            this.ligand = null;
            m.x = this.x;
            m.y = this.y;
        }
        return true;
    }

    public MoleculeListener getMoleculeListener() {
        return this.listener;
    }

    public void setMoleculeListener(MoleculeListener m) {
        this.listener = m;
    }

    public boolean fireMoleculeEvent() {
        if (this.listener != null) {
            return this.listener.moleculeEvent(this);
        }
        return false;
    }
}

