/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.kinetic;

import com.cudos.common.PaintableComponent;
import com.cudos.common.kinetic.Membrane;
import com.cudos.common.kinetic.Molecule;
import com.cudos.common.kinetic.MoleculeListener;
import java.awt.Graphics2D;
import java.util.Vector;

public abstract class MembraneTransporter
extends Molecule
implements PaintableComponent,
MoleculeListener {
    Vector walls = new Vector();
    Membrane membrane;
    protected int activeType = 1;
    protected int transportDirectionX;
    protected int transportDirectionY;

    public MembraneTransporter(Membrane mem, int along, int nw) {
        this.membrane = mem;
        if (this.membrane.horz) {
            this.x = along + this.membrane.pos.p1;
            this.y = this.membrane.pos.ordinate + Membrane.thickness / 2;
        } else {
            this.y = along + this.membrane.pos.p1;
            this.x = this.membrane.pos.ordinate - Membrane.thickness / 2;
        }
        this.setType(4);
        this.s = nw;
    }

    public void paint(Graphics2D g, boolean u) {
        if (u) {
            g.setColor(cols[this.getType()]);
            g.fillOval(this.x - this.s, this.y - this.s, this.s * 2, this.s * 2);
        }
    }

    public boolean moleculeEvent(Molecule m) {
        Molecule lig = null;
        if (!this.bound && (!m.isBound() || m.isBound() && (lig = m.getLigand()).getType() == 0)) {
            if (m.isBound()) {
                m.unbind();
            }
            this.transportDirectionY = 0;
            this.transportDirectionX = 0;
            if (this.membrane.horz) {
                this.transportDirectionY = m.y > this.y ? -1 : 1;
            } else {
                int n = this.transportDirectionX = m.x > this.x ? -1 : 1;
            }
            if (this.initTransport(m)) {
                m.setLigand(this);
                m.setBound(true);
                this.ligand = m;
                this.bound = true;
                m.setMoleculeListener(this);
                this.postInitTransport();
                return true;
            }
            return false;
        }
        if (m.getLigand() == this) {
            if (!this.continueTransport(m)) {
                m.setBound(false);
                m.setLigand(null);
                m.setMoleculeListener(null);
                this.bound = false;
                this.ligand = null;
                m.x += this.transportDirectionX * (4 + m.s);
                m.y += this.transportDirectionY * (4 + m.s);
            }
            return true;
        }
        return false;
    }

    public abstract boolean initTransport(Molecule var1);

    public abstract boolean continueTransport(Molecule var1);

    public void postInitTransport() {
    }
}

