/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.kinetic;

import com.cudos.common.PaintableComponent;
import com.cudos.common.kinetic.Molecule;
import com.cudos.common.kinetic.MoleculeListener;
import com.cudos.common.kinetic.Wall;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Random;

public class Membrane
implements PaintableComponent,
MoleculeListener {
    public Wall pos;
    public boolean horz = true;
    public static int thickness = 20;
    public static final int linew = 3;
    public double[] permeability = new double[]{0.9, 0.0, 0.1, 0.1, 0.0, 0.0};
    public Color bg = new Color(192, 224, 224);
    Random rand = new Random();

    public void paint(Graphics2D g, boolean u) {
        Color bla;
        Color yel = u ? Color.yellow : this.bg;
        Color color = bla = u ? Color.black : this.bg;
        if (this.horz) {
            g.setColor(yel);
            g.fillRect(this.pos.p1, this.pos.ordinate, this.pos.p2 - this.pos.p1, thickness);
            g.setColor(bla);
            g.setStroke(new BasicStroke(6.0f, 0, 2));
            g.drawLine(this.pos.p1, this.pos.ordinate + thickness - 3, this.pos.p2, this.pos.ordinate + thickness - 3);
            g.drawLine(this.pos.p1, this.pos.ordinate + 3, this.pos.p2, this.pos.ordinate + 3);
        } else {
            g.setColor(bla);
            g.drawLine(this.pos.ordinate, this.pos.p1, this.pos.ordinate, this.pos.p2);
        }
    }

    public Membrane() {
        this(true, 10, 0, 10);
    }

    public Membrane(boolean a, int o, int p, int q) {
        this.pos = new Wall(o, p, q);
        this.horz = a;
    }

    public boolean moleculeEvent(Molecule m) {
        if (this.rand.nextDouble() < this.permeability[m.getType()]) {
            if (this.horz) {
                m.y += m.vy / Math.abs(m.vy) * (thickness + 14);
            } else {
                m.x += m.vx / Math.abs(m.vx) * (thickness + 4);
            }
            return true;
        }
        return false;
    }
}

