/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.kinetic;

import com.cudos.common.PaintableComponent;
import com.cudos.common.kinetic.Antibody;
import com.cudos.common.kinetic.CircularWall;
import com.cudos.common.kinetic.MassiveMolecule;
import com.cudos.common.kinetic.Membrane;
import com.cudos.common.kinetic.MembraneTransporter;
import com.cudos.common.kinetic.Molecule;
import com.cudos.common.kinetic.SpecialWall;
import com.cudos.common.kinetic.Wall;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Timer;

public class KineticPane
extends JPanel
implements ActionListener {
    public Vector molecules;
    public Vector paintables;
    public Vector hwalls;
    public Vector vwalls;
    public Vector swalls;
    public Timer timer;
    Random rand = new Random();
    public int nCollisions = 0;

    public KineticPane() {
        this.molecules = new Vector();
        this.paintables = new Vector();
        this.hwalls = new Vector();
        this.vwalls = new Vector();
        this.swalls = new Vector();
        this.timer = new Timer(100, this);
        this.timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        Enumeration n = this.molecules.elements();
        while (n.hasMoreElements()) {
            boolean hitx = false;
            boolean hity = false;
            Molecule m = (Molecule)n.nextElement();
            if (g == null) {
                return;
            }
            m.paint(g, false);
            if (m.isBound() && (m.getLigand().getType() == 4 || m.getType() == 0 || m instanceof Antibody)) {
                m.fireMoleculeEvent();
            } else if (!(m instanceof MembraneTransporter)) {
                Wall w;
                int ny;
                int nx;
                MassiveMolecule mol;
                if (m instanceof MassiveMolecule) {
                    mol = (MassiveMolecule)m;
                    mol.move();
                    nx = (int)mol.x;
                    ny = (int)mol.y;
                } else {
                    nx = m.x + m.vx;
                    ny = m.y + m.vy;
                }
                Enumeration sw = this.swalls.elements();
                while (sw.hasMoreElements()) {
                    SpecialWall wl = (SpecialWall)sw.nextElement();
                    if (m instanceof MassiveMolecule) {
                        MassiveMolecule mol2 = (MassiveMolecule)m;
                        if (!wl.collisionTest(mol2, (double)nx, (double)ny)) continue;
                        mol2.move();
                        nx = (int)mol2.x;
                        ny = (int)mol2.y;
                        MassiveMolecule m2 = ((CircularWall)wl).M;
                        m2.paint((Graphics2D)this.getGraphics(), false);
                        m2.move();
                        m2.paint((Graphics2D)this.getGraphics(), true);
                        continue;
                    }
                    if (!wl.collisionTest(m, nx, ny)) continue;
                    nx = m.x + m.vx;
                    ny = m.y + m.vy;
                    ++this.nCollisions;
                }
                if (nx < 0 || nx > this.getWidth() - m.s) {
                    hitx = true;
                }
                Enumeration vw = this.vwalls.elements();
                while (vw.hasMoreElements()) {
                    w = (Wall)vw.nextElement();
                    if ((m.y > w.p2 || m.y + m.s < w.p1) && (ny > w.p2 || ny + m.s < w.p1) || (nx + m.s < w.ordinate || m.x >= w.ordinate) && (nx > w.ordinate || m.x + m.s <= w.ordinate)) continue;
                    if (w.action == 1 && w.fireMoleculeEvent(m)) {
                        nx = m.x;
                        ny = m.y;
                        break;
                    }
                    hitx = true;
                    break;
                }
                if (hitx) {
                    if (m instanceof MassiveMolecule) {
                        mol = (MassiveMolecule)m;
                        mol.x -= mol.vx;
                        mol.vx = -mol.vx;
                        nx = (int)mol.x;
                    } else {
                        m.vx = -m.vx;
                        nx = m.x;
                    }
                } else {
                    m.x = nx;
                }
                if (ny < 0 || ny > this.getHeight() - m.s) {
                    hity = true;
                }
                Enumeration hw = this.hwalls.elements();
                while (hw.hasMoreElements()) {
                    w = (Wall)hw.nextElement();
                    if ((m.x > w.p2 || m.x + m.s < w.p1) && (nx > w.p2 || nx + m.s < w.p1) || (ny + m.s < w.ordinate || m.y >= w.ordinate) && (ny > w.ordinate || m.y + m.s <= w.ordinate)) continue;
                    if (w.action == 1 && w.fireMoleculeEvent(m)) {
                        nx = m.x;
                        ny = m.y;
                        continue;
                    }
                    hity = true;
                }
                if (hity) {
                    if (m instanceof MassiveMolecule) {
                        mol = (MassiveMolecule)m;
                        mol.y -= mol.vy;
                        mol.vy = -mol.vy;
                        ny = (int)mol.y;
                    } else {
                        m.vy = -m.vy;
                        nx = m.y;
                    }
                } else {
                    m.y = ny;
                }
                if (m.getType() == 1 && !m.isBound()) {
                    int range = 20;
                    Enumeration m0 = this.molecules.elements();
                    while (m0.hasMoreElements()) {
                        Molecule tm = (Molecule)m0.nextElement();
                        if (tm.getType() != 0 || tm.isBound() || tm.x <= m.x - range || tm.x >= m.y + range || tm.y <= m.y - range || tm.y >= m.y + range || this.rand.nextInt(2) != 0) continue;
                        tm.setMoleculeListener(m);
                        m.setLigand(tm);
                        m.setBound(true);
                        tm.setLigand(m);
                        tm.setBound(true);
                        break;
                    }
                }
            }
            m.paint(g, true);
        }
    }

    public Membrane createMembraneAcross(int o, int p, int q) {
        Membrane m = new Membrane(true, o, p, q);
        Wall w1 = new Wall(o, p, q);
        this.hwalls.add(w1);
        Wall w2 = new Wall(o + Membrane.thickness, p, q);
        this.hwalls.add(w2);
        w1.setMoleculeListener(m);
        w2.setMoleculeListener(m);
        this.vwalls.add(new Wall(p, o, o + Membrane.thickness));
        this.vwalls.add(new Wall(q, o, o + Membrane.thickness));
        this.paintables.add(m);
        return m;
    }

    public MembraneTransporter createTransporter(Class transClass, Membrane mem, int along, int w) {
        MembraneTransporter t;
        try {
            Class<?> iclass = Class.forName("java.lang.Integer");
            Class[] pTypes = new Class[]{mem.getClass(), iclass, iclass};
            Object[] params = new Object[]{mem, new Integer(along), new Integer(w)};
            t = (MembraneTransporter)transClass.getConstructors()[0].newInstance(params);
            this.molecules.add(t);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        Wall w1 = new Wall(t.y - t.s - 1, t.x - t.s, t.x + t.s);
        this.hwalls.add(w1);
        Wall w2 = new Wall(t.y + t.s + 1, t.x - t.s, t.x + t.s);
        this.hwalls.add(w2);
        Wall w3 = new Wall(t.x - t.s, t.y - t.s, t.y + t.s);
        this.vwalls.add(w3);
        Wall w4 = new Wall(t.x + t.s, t.y - t.s, t.y + t.s);
        this.vwalls.add(w4);
        w1.setMoleculeListener(t);
        w2.setMoleculeListener(t);
        w3.setMoleculeListener(t);
        w4.setMoleculeListener(t);
        t.walls.add(w1);
        t.walls.add(w2);
        t.walls.add(w3);
        t.walls.add(w4);
        return t;
    }

    public void paint(Graphics g_) {
        super.paint(g_);
        Graphics2D g = (Graphics2D)g_;
        Enumeration e = this.molecules.elements();
        while (e.hasMoreElements()) {
            ((PaintableComponent)e.nextElement()).paint(g, true);
        }
        e = this.paintables.elements();
        while (e.hasMoreElements()) {
            ((PaintableComponent)e.nextElement()).paint(g, true);
        }
    }

    public int getMoleculesAbove(int lev, int type) {
        int count = 0;
        Enumeration e = this.molecules.elements();
        while (e.hasMoreElements()) {
            Molecule m = (Molecule)e.nextElement();
            if (m.getType() != type || m.y >= lev) continue;
            ++count;
        }
        return count;
    }

    public Molecule getAMolecule(Random r, int type) {
        Molecule m;
        int tries = 0;
        while ((m = (Molecule)this.molecules.get(r.nextInt(this.molecules.size()))).getType() != type && ++tries < 10) {
        }
        if (tries < 10) {
            return m;
        }
        return null;
    }

    public void setMoleculeSizes(int type, int size) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        Enumeration e = this.molecules.elements();
        while (e.hasMoreElements()) {
            Molecule m = (Molecule)e.nextElement();
            if (m.getType() != type) continue;
            m.paint(g, false);
            m.s = size;
            this.timer.restart();
            if (m.isBound()) continue;
            this.eliminateIntersections(m);
        }
    }

    private void eliminateIntersections(Molecule m) {
        Wall w;
        if (m.ligand != null) {
            System.out.println("Oops, moving bound mol");
        }
        Enumeration vw = this.vwalls.elements();
        while (vw.hasMoreElements()) {
            w = (Wall)vw.nextElement();
            if (m.y > w.p2 || m.y + m.s < w.p1 || m.x > w.ordinate || m.x + m.s < w.ordinate) continue;
            m.x -= m.s;
        }
        Enumeration hw = this.hwalls.elements();
        while (hw.hasMoreElements()) {
            w = (Wall)hw.nextElement();
            if (m.x > w.p2 || m.x + m.s < w.p1 || m.y > w.ordinate || m.y + m.s < w.ordinate) continue;
            m.y -= m.s;
        }
    }

    public void removeMolecules(int type) {
        Vector<Molecule> toRemove = new Vector<Molecule>();
        Enumeration e = this.molecules.elements();
        while (e.hasMoreElements()) {
            Molecule m = (Molecule)e.nextElement();
            if (m.getType() != type) continue;
            if (m.isBound()) {
                m.unbind();
            }
            toRemove.add(m);
            if (!(m instanceof MembraneTransporter)) continue;
            this.hwalls.removeAll(((MembraneTransporter)m).walls);
            this.vwalls.removeAll(((MembraneTransporter)m).walls);
        }
        this.molecules.removeAll(toRemove);
    }

    public void finalize() throws Throwable {
        this.timer.stop();
        super.finalize();
    }
}

