/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.kinetic;

import com.cudos.common.kinetic.Membrane;
import com.cudos.common.kinetic.MembraneTransporter;
import com.cudos.common.kinetic.Molecule;
import java.awt.Color;
import java.awt.Graphics2D;

public class DiffusionChannel
extends MembraneTransporter {
    int frame = 0;
    int numframes = 5;

    public DiffusionChannel(Membrane mem, int along, int w) {
        super(mem, along, w);
        this.activeType = 1;
    }

    public void paint(Graphics2D g, boolean u) {
        g.setColor(this.bg);
        g.fillRect(this.x + this.s / 3, this.y - this.s, this.s / 3, 2 * this.s);
        g.setColor(Color.blue);
        g.fillOval(this.x, this.y - this.s, this.s / 3, 2 * this.s);
        g.fillOval(this.x + 2 * this.s / 3, this.y - this.s, this.s / 3, 2 * this.s);
    }

    public boolean initTransport(Molecule m) {
        if (m.getType() == this.activeType) {
            m.x = this.x + this.s / 2 - m.s / 2;
            m.y = this.y - this.transportDirectionY * this.s / 2;
            this.frame = this.numframes;
            return true;
        }
        return false;
    }

    public boolean continueTransport(Molecule m) {
        m.y += this.transportDirectionY * Membrane.thickness / this.numframes;
        if (this.frame-- > 0) {
            m.vy = this.transportDirectionY * Math.abs(m.vy);
            m.y += this.transportDirectionY * 5;
            return true;
        }
        return false;
    }
}

