/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.kinetic;

import com.cudos.common.kinetic.MassiveMolecule;
import com.cudos.common.kinetic.Molecule;
import com.cudos.common.kinetic.SpecialWall;
import com.cudos.common.kinetic.Wall;

public class CircularWall
extends Wall
implements SpecialWall {
    public MassiveMolecule M;
    public double r;

    public boolean collisionTest(MassiveMolecule m, double nx, double ny) {
        double dx = m.x + (double)(m.s / 2) - (this.M.x + (double)(this.M.s / 2));
        double dy = m.y + (double)(m.s / 2) - (this.M.y + (double)(this.M.s / 2));
        double ndx = nx + (double)(m.s / 2) - (this.M.x + (double)(this.M.s / 2));
        double ndy = ny + (double)(m.s / 2) - (this.M.y + (double)(this.M.s / 2));
        if (m != this.M && (dx * dx + dy * dy < (double)(this.M.s * this.M.s / 4 + m.s * m.s / 4) || ndx * ndx + ndy * ndy < (double)(this.M.s * this.M.s / 4 + m.s * m.s / 4))) {
            double Mass = this.M.Mass;
            double al = Math.atan2(dy, dx);
            double th1 = Math.atan2(m.vy, m.vx) - al;
            double ph1 = Math.atan2(this.M.vy, this.M.vx) - al;
            double v1 = Math.sqrt(m.vx * m.vx + m.vy * m.vy);
            double V1 = Math.sqrt(this.M.vx * this.M.vx + this.M.vy * this.M.vy);
            double mass = m.Mass;
            double th2 = Math.atan2(v1 * Math.sin(th1) * (mass + Mass), (mass - Mass) * v1 * Math.cos(th1) + 2.0 * Mass * V1 * Math.cos(ph1));
            double ph2 = Math.atan2(V1 * Math.sin(ph1) * (Mass + mass), 2.0 * mass * v1 * Math.cos(th1) + (Mass - mass) * V1 * Math.cos(ph1));
            double V2 = Math.sqrt(Math.pow((2.0 * mass * v1 * Math.cos(th1) + (Mass - mass) * V1 * Math.cos(ph1)) / (mass + Mass), 2.0) + V1 * V1 * Math.sin(ph1) * Math.sin(ph1));
            double v2 = Math.sqrt(Math.pow(((mass - Mass) * v1 * Math.cos(th1) + 2.0 * Mass * V1 * Math.cos(ph1)) / (mass + Mass), 2.0) + v1 * v1 * Math.sin(th1) * Math.sin(th1));
            m.vx = v2 * Math.cos(th2 + al);
            m.vy = v2 * Math.sin(th2 + al);
            this.M.vx = V2 * Math.cos(ph2 + al);
            this.M.vy = V2 * Math.sin(ph2 + al);
            return true;
        }
        return false;
    }

    public boolean collisionTest(Molecule m, int nx, int ny) {
        double dx = (double)(m.x - m.s / 2) - (this.M.x + (double)(this.M.s / 2));
        double dy = (double)(m.y - m.s / 2) - (this.M.y + (double)(this.M.s / 2));
        double ndx = (double)(nx - m.s / 2) - (this.M.x + (double)(this.M.s / 2));
        double ndy = (double)(ny - m.s / 2) - (this.M.y + (double)(this.M.s / 2));
        if (m != this.M && (dx * dx + dy * dy < this.r * this.r + (double)(m.s * m.s / 4) || ndx * ndx + ndy * ndy < this.r * this.r + (double)(m.s * m.s / 4))) {
            double Mass = this.M.Mass;
            double al = Math.atan2(dy, dx);
            double th1 = Math.atan2(m.vy, m.vx) - al;
            double ph1 = Math.atan2(this.M.vy, this.M.vx) - al;
            double v1 = Math.sqrt(m.vx * m.vx + m.vy * m.vy);
            double V1 = Math.sqrt(this.M.vx * this.M.vx + this.M.vy * this.M.vy);
            double mass = 1.0;
            double th2 = Math.atan2(v1 * Math.sin(th1) * (mass + Mass), (mass - Mass) * v1 * Math.cos(th1) + 2.0 * Mass * V1 * Math.cos(ph1));
            double ph2 = Math.atan2(V1 * Math.sin(ph1) * (Mass + mass), 2.0 * mass * v1 * Math.cos(th1) + (Mass - mass) * V1 * Math.cos(ph1));
            double V2 = Math.sqrt(Math.pow((2.0 * mass * v1 * Math.cos(th1) + (Mass - mass) * V1 * Math.cos(ph1)) / (mass + Mass), 2.0) + V1 * V1 * Math.sin(ph1) * Math.sin(ph1));
            double v2 = Math.sqrt(Math.pow(((mass - Mass) * v1 * Math.cos(th1) + 2.0 * Mass * V1 * Math.cos(ph1)) / (mass + Mass), 2.0) + v1 * v1 * Math.sin(th1) * Math.sin(th1));
            m.vx = (int)(v2 * Math.cos(th2 + al));
            m.vy = (int)(v2 * Math.sin(th2 + al));
            this.M.vx = V2 * Math.cos(ph2 + al);
            this.M.vy = V2 * Math.sin(ph2 + al);
            return true;
        }
        return false;
    }

    public CircularWall(MassiveMolecule mol, double radius) {
        this.r = radius;
        this.M = mol;
    }
}

