/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.kinetic;

import com.cudos.common.kinetic.Antibody;
import com.cudos.common.kinetic.CircularBindableWall;
import com.cudos.common.kinetic.KineticPane;
import com.cudos.common.kinetic.MassiveMolecule;
import com.cudos.common.kinetic.Molecule;
import com.cudos.common.kinetic.SpecialWall;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Random;
import java.util.Vector;

public class Cell
extends MassiveMolecule {
    public Image im;
    KineticPane parent;
    public SpecialWall swall;
    Vector theta = new Vector();
    Vector abs = new Vector();

    public Cell(int nx, int ny, KineticPane k) {
        super(nx, ny);
        this.parent = k;
        this.setType(6);
        this.s = 70;
        this.swall = new CircularBindableWall(this, 70.0);
        k.swalls.add(this.swall);
        this.Mass = 40.0;
    }

    public Cell(Random rand, Rectangle rect, KineticPane k) {
        super(rand, rect);
        this.parent = k;
        this.setType(6);
        this.s = 70;
        this.swall = new CircularBindableWall(this, 70.0);
        k.swalls.add(this.swall);
        this.Mass = 400.0;
    }

    public void paint(Graphics2D g, boolean u) {
        if (u) {
            if (this.im != null) {
                g.drawImage(this.im, (int)this.x, (int)this.y, this.parent);
                g.setColor(Color.blue);
                g.setStroke(new BasicStroke(4.0f));
            }
        } else {
            g.setColor(this.bg);
            g.fillOval((int)this.x - 2, (int)this.y - 2, 55, 55);
            g.setStroke(new BasicStroke(4.0f));
        }
    }

    public boolean moleculeEvent(Molecule m) {
        if (m instanceof MassiveMolecule && this instanceof MassiveMolecule) {
            MassiveMolecule mol = (MassiveMolecule)m;
            mol.x = this.x - (double)mol.s;
            mol.y = this.y;
            if (mol instanceof Antibody) {
                double a;
                if (this.abs.indexOf(mol) < 0) {
                    this.abs.add(mol);
                    a = Math.PI * 2 * this.rand.nextDouble();
                    this.theta.add(new Double(a));
                } else {
                    a = (Double)this.theta.get(this.abs.indexOf(mol));
                    System.out.println(a);
                }
                ((Antibody)mol).theta = a;
                mol.x = this.x + (double)(this.s / 2) * Math.cos(a);
                mol.y = this.y + (double)(this.s / 2) * Math.sin(a);
            }
        } else {
            m.x = (int)(this.x - (double)m.s);
            m.y = (int)this.y;
        }
        if (this.rand.nextInt(200) == 0) {
            m.setMoleculeListener(null);
            m.setBound(false);
            m.setLigand(null);
            this.bound = false;
            this.ligand = null;
            m.x = (int)this.x;
            m.y = (int)this.y;
            this.theta.remove(this.abs.indexOf(m));
            this.abs.remove(m);
        }
        return true;
    }
}

