/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.kinetic;

import com.cudos.common.kinetic.Membrane;
import com.cudos.common.kinetic.MembraneTransporter;
import com.cudos.common.kinetic.Molecule;
import java.awt.Color;
import java.awt.Graphics2D;

public class Antiporter
extends MembraneTransporter {
    boolean transporting = false;
    boolean nBound = false;
    boolean sBound = false;
    Color molbg;
    Color pumpColor = Color.pink;
    Molecule na;
    Molecule su;
    int frame = 0;
    int frames = 8;

    public boolean initTransport(Molecule m) {
        if (!this.transporting && m.getType() == 2 && this.transportDirectionY < 0 && !this.nBound) {
            this.na = m;
            m.y = this.y + this.s - m.s;
            m.x = this.x - this.s + 4 * this.s / 3 - m.s / 2;
            this.molbg = m.bg;
            m.bg = this.pumpColor;
            this.nBound = true;
            if (this.sBound) {
                this.transporting = true;
                this.frame = this.frames;
            }
            return true;
        }
        if (!this.transporting && m.getType() == 1 && this.transportDirectionY > 0 && !this.sBound) {
            this.su = m;
            m.y = this.y - this.s;
            m.x = this.x - this.s + 2 * this.s / 3 - m.s / 2;
            this.molbg = m.bg;
            m.bg = this.pumpColor;
            this.sBound = true;
            if (this.nBound) {
                this.transporting = true;
                this.frame = this.frames;
            }
            return true;
        }
        return false;
    }

    public void postInitTransport() {
        if (!this.transporting) {
            this.bound = false;
            this.ligand = null;
        }
    }

    public boolean continueTransport(Molecule m) {
        if (this.transporting) {
            if (m.getType() == 2) {
                m.y -= 3 * this.s / this.frames;
                if (m.y <= this.y - this.s - m.s) {
                    m.bg = this.molbg;
                }
            } else if (m.getType() == 1) {
                m.y += 3 * this.s / this.frames;
                if (m.y >= this.y + this.s) {
                    m.bg = this.molbg;
                }
            }
            if (m == this.na) {
                --this.frame;
            }
            if (this.frame <= 0) {
                int d;
                int n = d = m.getType() == 1 ? 1 : -1;
                if (d == 1) {
                    this.nBound = false;
                } else {
                    this.sBound = false;
                }
                if (!this.nBound && !this.sBound) {
                    this.transporting = false;
                }
                m.bg = this.molbg;
                m.y += d * m.s + 2;
                m.vy = d * Math.abs(m.vy);
                return false;
            }
        }
        return true;
    }

    public void paint(Graphics2D g, boolean u) {
        g.setColor(this.bg);
        g.fillRect(this.x - this.s + 2 * this.s / 3, this.y - this.s, 2 * this.s / 3, 2 * this.s);
        g.setColor(this.pumpColor);
        g.fillRoundRect(this.x - this.s, this.y - this.s, 2 * this.s / 3, 2 * this.s, 4, 4);
        g.fillRoundRect(this.x - this.s + 4 * this.s / 3, this.y - this.s, 2 * this.s / 3, 2 * this.s, 4, 4);
    }

    public Antiporter(Membrane m, int a, int w) {
        super(m, a, w);
    }
}

