/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.function;

import com.cudos.SimpleFormulaGraphExhibit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GraphLibraryPanel
extends JPanel {
    private JScrollPane jScrollPane1;
    private JTextArea descriptiontext;
    private JScrollPane jScrollPane2;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JList equationlist;
    private JTextField equationtext;
    private JComboBox categorylist;
    Properties properties = new Properties();
    DefaultComboBoxModel categorymodel = new DefaultComboBoxModel();
    DefaultListModel equationlistmodel = new DefaultListModel();
    public SimpleFormulaGraphExhibit exhibit;

    public GraphLibraryPanel() {
        this.gui();
        try {
            this.properties.load(this.getClass().getResourceAsStream("GraphLibrary.txt"));
            String[] cats = ((String)this.properties.get("Categories")).split(",");
            int i = 0;
            while (i < cats.length) {
                this.categorymodel.addElement(cats[i].trim());
                ++i;
            }
            this.categorylist.setModel(this.categorymodel);
            this.categorylist.setSelectedIndex(0);
            this.updateequations();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            System.out.println("Syntax error in graph library");
            e.printStackTrace();
        }
    }

    private void gui() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            thisLayout.setHgap(2);
            thisLayout.setVgap(2);
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(50, 300));
            this.jScrollPane1 = new JScrollPane();
            this.add((Component)this.jScrollPane1, "Center");
            this.jScrollPane1.setSize(20, 20);
            this.equationlist = new JList();
            this.jScrollPane1.setViewportView(this.equationlist);
            this.equationlist.setModel(this.equationlistmodel);
            this.equationlist.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    GraphLibraryPanel.this.updateselection();
                }
            });
            this.jPanel1 = new JPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout);
            this.add((Component)this.jPanel1, "South");
            this.equationtext = new JTextField();
            this.jPanel1.add(this.equationtext);
            this.equationtext.setEditable(false);
            this.jScrollPane2 = new JScrollPane();
            this.jPanel1.add((Component)this.jScrollPane2, "North");
            this.jScrollPane2.setHorizontalScrollBarPolicy(31);
            this.descriptiontext = new JTextArea();
            this.jScrollPane2.setViewportView(this.descriptiontext);
            this.descriptiontext.setEditable(false);
            this.descriptiontext.setRows(5);
            this.descriptiontext.setLineWrap(true);
            this.descriptiontext.setWrapStyleWord(true);
            this.descriptiontext.setSize(2, 2);
            this.jPanel2 = new JPanel();
            BorderLayout jPanel2Layout = new BorderLayout();
            jPanel2Layout.setVgap(2);
            this.jPanel2.setLayout(jPanel2Layout);
            this.add((Component)this.jPanel2, "North");
            this.categorylist = new JComboBox();
            this.jPanel2.add((Component)this.categorylist, "Center");
            this.categorylist.setEditable(false);
            this.categorylist.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    GraphLibraryPanel.this.updateequations();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateequations() {
        this.equationlistmodel.removeAllElements();
        String eq = "";
        String category = (String)this.categorylist.getSelectedItem();
        if (category != null && category instanceof String && category.length() > 0) {
            String[] eqs = ((String)this.properties.get(category)).split(",");
            int i = 0;
            while (i < eqs.length) {
                String eqtxt = this.properties.getProperty(eqs[i].trim());
                if (eqtxt != null && eqtxt.length() > 0) {
                    this.equationlistmodel.addElement(eqs[i].trim());
                }
                ++i;
            }
        }
    }

    protected void updateselection() {
        String eqtxt = "";
        String description = "";
        String eq = (String)this.equationlist.getSelectedValue();
        if (eq != null && eq.length() > 0) {
            eqtxt = (String)this.properties.get(eq);
            if (this.exhibit != null && eqtxt != null && eqtxt.length() > 0) {
                int jcomm = (eqtxt = eqtxt.trim()).indexOf("//");
                if (jcomm >= 0) {
                    description = eqtxt.substring(jcomm + 2);
                    eqtxt = eqtxt.substring(0, jcomm).trim();
                }
                this.exhibit.expressionPanel.setExpression(eqtxt);
                this.equationtext.setText(eqtxt);
            }
        }
        if (eq == null) {
            eq = "";
        }
        this.equationtext.setText(eq);
        this.descriptiontext.setText(description);
        this.descriptiontext.setCaretPosition(0);
    }
}

