/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.function;

import com.cudos.common.function.Function;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class FunctionDisplay
extends JPanel {
    Function function;
    int strokeThickness = 3;
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;

    public void paint(Graphics g_) {
        super.paint(g_);
        Graphics2D g = (Graphics2D)g_;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getForeground());
        g.setStroke(new BasicStroke(this.strokeThickness));
        int ox = 0;
        int oy = this.fgY(this.gfX(0));
        int i = 0;
        while (i < this.getWidth()) {
            int n = oy;
            oy = this.fgY(this.function.getY(this.gfX(i)));
            g.drawLine(ox, n, i, oy);
            ++i;
        }
    }

    int fgX(double x) {
        return (int)((x - this.xmin) * (double)this.getWidth() / (this.xmax - this.xmin));
    }

    int fgY(double y) {
        return (int)((y - this.ymin) * (double)this.getHeight() / (this.ymax - this.ymin));
    }

    double gfX(int x) {
        return (double)x * (this.xmax - this.xmin) / (double)this.getWidth() + this.xmin;
    }

    double gfY(int y) {
        return (double)y * (this.ymax - this.ymin) / (double)this.getHeight() + this.ymin;
    }

    public void setFunction(Function f) {
        this.function = f;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setStrokeThickness(int t) {
        this.strokeThickness = t;
    }

    public int getStrokeThickness() {
        return this.strokeThickness;
    }

    public void setDisplayArea(Rectangle2D r) {
        this.xmin = r.getX();
        this.xmax = r.getX() + r.getWidth();
        this.ymin = r.getY();
        this.ymax = r.getY() + r.getHeight();
    }

    public Rectangle2D getDisplayArea() {
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public FunctionDisplay() {
        this.setBackground(Color.black);
        this.setForeground(Color.green);
    }
}

