/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.function;

import com.cudos.common.function.FunctionWithoutParameters;

public class FastFourier
extends FunctionWithoutParameters {
    public double[] bucket;
    private int nB;

    public FastFourier(int nBuckets) {
        this.nB = nBuckets;
        this.bucket = new double[nBuckets];
    }

    public void zero() {
        int i = 0;
        while (i < this.nB) {
            this.bucket[i] = 0.0;
            ++i;
        }
    }

    public void tick(double value) {
        int i = 0;
        while (i < this.nB) {
            int n = i;
            this.bucket[n] = this.bucket[n] + value;
            int n2 = i;
            this.bucket[n2] = this.bucket[n2] * (double)(i / this.nB);
            ++i;
        }
    }

    public double getY(double x) {
        return this.bucket[(int)(x * (double)this.nB)];
    }
}

