/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

public class ValueSliderEditor
extends JPanel
implements TableCellEditor {
    JTable table;
    Object value;
    int row;
    int column;
    double smin;
    double smax;
    private MyCEL cel = new MyCEL();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JSlider jSlider1 = new JSlider();
    private JTextField jTextField1 = new JTextField();
    boolean doupdate = true;

    public ValueSliderEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.value = value;
        this.row = row;
        this.column = column;
        this.init();
        return this;
    }

    public Object getCellEditorValue() {
        return new Double(this.getText());
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    public boolean stopCellEditing() {
        this.table.setValueAt(this.getCellEditorValue(), this.row, this.column);
        this.cel.editingStopped(new ChangeEvent(this));
        return true;
    }

    public void cancelCellEditing() {
        this.cel.editingCanceled(new ChangeEvent(this));
    }

    void init() {
        if (this.value instanceof Number) {
            double v = ((Number)this.value).doubleValue();
            this.doupdate = false;
            this.setSlider(v);
            this.doupdate = true;
        }
        this.jTextField1.setText(this.value.toString());
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.cel.list.add(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.cel.list.remove(l);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jTextField1.setBorder(null);
        this.jTextField1.setToolTipText("");
        this.jTextField1.setColumns(8);
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ValueSliderEditor.this.jTextField1_actionPerformed(e);
            }
        });
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ValueSliderEditor.this.jSlider1_stateChanged(e);
            }
        });
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jSlider1, "Center");
        this.add((Component)this.jTextField1, "East");
    }

    void setSlider(double v) {
        this.smin = v / 5.0;
        this.smax = v * 5.0;
        if (v == 0.0) {
            this.smin = -1.0;
            this.smax = 1.0;
        }
        this.jSlider1.setValue((int)(100.0 * ((v - this.smin) / (this.smax - this.smin))));
    }

    double getSlider() {
        return (double)this.jSlider1.getValue() * (this.smax - this.smin) / 100.0 + this.smin;
    }

    double getText() {
        return Double.parseDouble(this.jTextField1.getText());
    }

    void jTextField1_actionPerformed(ActionEvent e) {
        double v = this.getText();
        this.doupdate = false;
        this.setSlider(v);
        this.doupdate = true;
    }

    void jSlider1_stateChanged(ChangeEvent e) {
        if (this.doupdate) {
            double v = this.getSlider();
            int exp = (int)Math.floor(Math.log(v) / Math.log(10.0)) - 6;
            v = (double)Math.round(v / Math.pow(10.0, exp)) * Math.pow(10.0, exp);
            this.jTextField1.setText(String.valueOf(v));
            this.table.getModel().setValueAt(this.getCellEditorValue(), this.row, this.column);
        }
    }

    private class MyCEL
    implements CellEditorListener {
        Vector list = new Vector();

        private MyCEL() {
        }

        public void editingCanceled(ChangeEvent e) {
            int i = 0;
            while (i < this.list.size()) {
                ((CellEditorListener)this.list.get(i)).editingCanceled(e);
                ++i;
            }
        }

        public void editingStopped(ChangeEvent e) {
            int i = 0;
            while (i < this.list.size()) {
                ((CellEditorListener)this.list.get(i)).editingStopped(e);
                ++i;
            }
        }
    }
}

