/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import java.awt.Color;

public class Spectrum {
    static Object[][] data = new Object[][]{{new Integer(300), Color.blue}, {new Integer(400), Color.green}, {new Integer(500), Color.yellow}, {new Integer(600), Color.red}, {new Integer(700), Color.magenta}};

    public static Color getColorForWavelength(int wavelength) {
        Color previous = Color.black;
        int prevw = 0;
        int i = 0;
        while (i < data.length) {
            int w = (Integer)data[i][0];
            Color c = (Color)data[i][1];
            if (wavelength < w) {
                float fraction = (float)(wavelength - prevw) / (float)(w - prevw);
                return Spectrum.mix(fraction, previous, c);
            }
            previous = c;
            prevw = w;
            ++i;
        }
        return Spectrum.mix((float)(wavelength - prevw) / (float)(1000 - prevw), previous, Color.black);
    }

    static Color mix(float f, Color a, Color b) {
        return new Color((int)Math.min(Math.max(0.0f, (float)a.getRed() + f * (float)(b.getRed() - a.getRed())), 255.0f), (int)Math.min(Math.max(0.0f, (float)a.getGreen() + f * (float)(b.getGreen() - a.getGreen())), 255.0f), (int)Math.min(Math.max(0.0f, (float)a.getBlue() + f * (float)(b.getBlue() - a.getBlue())), 255.0f));
    }
}

