/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.Array;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;

public class Oscilloscope
extends JPanel
implements ActionListener {
    public JButton sweep;
    public JButton clear;
    public Timer timer;
    protected int posX;
    protected int[] posY;
    protected int[] baseY;
    protected int nTraces;
    public OScreen graph;
    public int xSpeed = 1;
    private ActionListener listener;
    public Panel buttons;

    public Oscilloscope() {
        this(1, null);
    }

    public Oscilloscope(int n, ActionListener list) {
        this.listener = list;
        this.nTraces = n;
        this.posY = new int[this.nTraces];
        this.baseY = new int[this.nTraces];
        this.setLayout(new BorderLayout());
        this.buttons = new Panel();
        this.buttons.setLayout(new GridLayout());
        this.sweep = new JButton("Sweep");
        this.buttons.add(this.sweep);
        this.sweep.addActionListener(this);
        this.clear = new JButton("Clear");
        this.buttons.add(this.clear);
        this.add((Component)this.buttons, "South");
        this.clear.addActionListener(this);
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Oscilloscope.this.tick();
            }
        });
        this.graph = new OScreen();
        this.add((Component)this.graph, "Center");
        Color[] cols = new Color[this.nTraces];
        Color[] seq = new Color[]{Color.green, Color.red, Color.yellow, Color.white};
        int i = 0;
        while (i < this.nTraces) {
            cols[i] = seq[i % Array.getLength(seq)];
            ++i;
        }
        this.graph.init(cols);
        this.graph.repaint();
    }

    public void setNTraces(int n) {
        this.nTraces = n;
        this.posY = new int[this.nTraces];
        this.baseY = new int[this.nTraces];
        Color[] cols = new Color[this.nTraces];
        Color[] seq = new Color[]{Color.green, Color.red, Color.yellow, Color.white};
        int i = 0;
        while (i < this.nTraces) {
            cols[i] = seq[i % Array.getLength(seq)];
            ++i;
        }
        this.graph.init(cols);
        this.graph.repaint();
    }

    public void tick() {
        if ((this.posX += this.xSpeed) > this.graph.getDataWidth()) {
            this.timer.stop();
        } else {
            this.graph.pOld = this.graph.pNew;
            this.graph.pNew = new Point2D.Float[this.graph.getNTraces()];
            this.setNewPoint();
            this.graph.paintTraces();
        }
    }

    public void drawScreenElements(Graphics2D g) {
    }

    private void setNewPoint() {
        int i = 0;
        while (i < this.graph.getNTraces()) {
            ((OScreen)this.graph).pNew[i] = new Point2D.Float(this.posX, this.posY[i]);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Sweep") {
            if (this.listener != null) {
                this.listener.actionPerformed(e);
            }
            this.posX = 0;
            this.setNewPoint();
            this.timer.start();
        } else if (e.getActionCommand() == "Clear") {
            this.graph.repaint();
        }
    }

    public void setPosY(int[] ny) {
        this.posY = ny;
    }

    public int[] getPosY() {
        return this.posY;
    }

    public void setPosX(int nx) {
        this.posX = nx;
    }

    public int getPosX() {
        return this.posX;
    }

    public int[] getBaseY() {
        return this.baseY;
    }

    public void setBaseY(int[] nb) {
        this.baseY = nb;
    }

    public void setColors(Color[] c) {
        this.graph.color = c;
    }

    public Color[] getColors() {
        return this.graph.color;
    }

    public int getGutter() {
        return this.graph.gutter;
    }

    public void setGutter(int g) {
        this.graph.gutter = g;
    }

    public void finalize() throws Throwable {
        this.timer.stop();
        super.finalize();
    }

    public class OScreen
    extends Panel {
        private Point2D.Float[] pOld;
        private Point2D.Float[] pNew;
        private Color[] color;
        private Border bevel;
        private int gutter = 10;

        public int getNTraces() {
            return Array.getLength(this.color);
        }

        public void init(Color[] c) {
            this.color = c;
            this.pOld = new Point2D.Float[this.getNTraces()];
            this.pNew = new Point2D.Float[this.getNTraces()];
            int i = 0;
            while (i < this.getNTraces()) {
                this.pOld[i] = new Point2D.Float(0.0f, 0.0f);
                this.pNew[i] = new Point2D.Float(0.0f, 0.0f);
                ++i;
            }
            this.bevel = BorderFactory.createLoweredBevelBorder();
            Oscilloscope.this.setBorder(this.bevel);
        }

        public void paint(Graphics g_) {
            super.paint(g_);
            Graphics2D g = (Graphics2D)g_;
            g.setColor(Color.black);
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(this.gutter, this.gutter, this.getWidth() - 2 * this.gutter, this.getHeight() - 2 * this.gutter, 20.0, 20.0);
            g.fill(rect);
            Oscilloscope.this.drawScreenElements(g);
        }

        public float calcY(float y, int base) {
            float i = (float)this.gutter + y * (float)(this.getHeight() - 2 * this.gutter) / 1024.0f;
            if ((i += (float)base) < (float)this.gutter) {
                i = this.gutter;
            }
            if (i > (float)(this.getHeight() - this.gutter)) {
                i = this.getHeight() - this.gutter;
            }
            return i;
        }

        public int getDataWidth() {
            return this.getWidth() - 2 * this.gutter;
        }

        private void paintTraces() {
            Graphics2D g = (Graphics2D)this.getGraphics();
            int trace = 0;
            while (trace < Array.getLength(this.pOld)) {
                g.setColor(this.color[trace]);
                g.draw(new Line2D.Float((float)this.gutter + this.pOld[trace].x, this.calcY(this.pOld[trace].y, Oscilloscope.this.baseY[trace]), (float)this.gutter + this.pNew[trace].x, this.calcY(this.pNew[trace].y, Oscilloscope.this.baseY[trace])));
                ++trace;
            }
        }

        public void finalize() throws Throwable {
            Oscilloscope.this.timer.stop();
            super.finalize();
        }
    }
}

