/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import com.cudos.common.CudosExhibit;
import com.cudos.common.CudosTest;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class MultipleChoiceTest
extends CudosExhibit {
    boolean passEnabled = true;
    boolean feedbackEnabed = true;
    boolean randomiseAnswers = true;
    boolean messageDialogIfCorrect = false;
    boolean messageDialogIfIncorrect = true;
    String name = "";
    String[] questions;
    String[][] answers;
    int[] correctAnswer;
    int correct;
    int currentQuestion;
    int[] order;
    ActionListener buttonAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            int b = Integer.parseInt(e.getActionCommand());
            if (b != MultipleChoiceTest.this.correctAnswer[MultipleChoiceTest.this.order[MultipleChoiceTest.this.currentQuestion]]) {
                MultipleChoiceTest.this.incorrectAnswerPressed();
            } else {
                MultipleChoiceTest.this.correctAnswerPressed();
            }
        }
    };
    JButton[] answerButtons = new JButton[4];
    Font bigFont = new Font("Dialog", 1, 16);
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea questiontext = new JTextArea();
    JPanel jPanel5 = new JPanel();
    JButton exitbutton = new JButton();
    JButton passbutton = new JButton();
    JPanel jPanel6 = new JPanel();
    JLabel questionnumber = new JLabel();
    JLabel scoretext = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel totaltext = new JLabel();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel answerspanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    Border border2;

    public MultipleChoiceTest() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < this.answerButtons.length) {
            JButton b;
            this.answerButtons[i] = b = new JButton();
            b.setFont(this.bigFont);
            b.setActionCommand(String.valueOf(i));
            b.addActionListener(this.buttonAction);
            this.answerspanel.add((Component)b, null);
            ++i;
        }
        this.setPassEnabled(false);
    }

    public void postinit() {
        super.postinit();
        String qfile = this.getApplet().getParameter("questions");
        if (qfile != null) {
            this.setupFromFile(qfile);
        }
    }

    public void setupFromFile(String filename) {
        String name = new File(filename).getName();
        name = name.substring(0, name.lastIndexOf("."));
        try {
            this.setupFrom(this.getApplet().getResourceURL(filename).openStream(), name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setupFrom(InputStream is, String name) throws IOException {
        this.name = name;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        Vector<String> qs = new Vector<String>();
        Vector<String> as = new Vector<String>();
        Vector<Integer> ca = new Vector<Integer>();
        int NA = 0;
        int na = 0;
        boolean newQ = true;
        while (line != null) {
            if (!(line = line.trim()).equals("")) {
                if (newQ) {
                    qs.add(line);
                    newQ = false;
                    na = 0;
                } else {
                    if (line.startsWith("*")) {
                        line = line.substring(1);
                        ca.add(new Integer(na));
                    }
                    as.add(line);
                    ++na;
                }
            } else {
                if (qs.size() == 1) {
                    NA = na;
                } else if (na != NA) {
                    throw new IllegalArgumentException("Wrong number of answers to question " + qs.size());
                }
                if (qs.size() != ca.size()) {
                    throw new IllegalArgumentException("Wrong number of correct answers (asterisks) at question " + qs.size());
                }
                newQ = true;
            }
            line = br.readLine();
        }
        this.questions = new String[qs.size()];
        this.answers = new String[qs.size()][NA];
        this.correctAnswer = new int[qs.size()];
        int i = 0;
        while (i < qs.size()) {
            this.questions[i] = (String)qs.get(i);
            int j = 0;
            while (j < NA) {
                this.answers[i][j] = (String)as.get(i * NA + j);
                ++j;
            }
            this.correctAnswer[i] = (Integer)ca.get(i);
            ++i;
        }
        this.initialiseTest();
        this.nextQuestion();
    }

    protected void initialiseTest() {
        this.correct = 0;
        this.currentQuestion = 0;
        this.order = CudosTest.randomizeOrder(this.questions.length);
        this.scoretext.setText("0");
    }

    void passbutton_actionPerformed(ActionEvent e) {
        this.incorrectAnswerPressed();
    }

    protected void correctAnswerPressed() {
        ++this.correct;
        if (this.feedbackEnabed) {
            CudosTest.showCorrectMessage("", this, this.messageDialogIfCorrect);
            this.scoretext.setText(String.valueOf(this.correct));
        }
        ++this.currentQuestion;
        if (this.currentQuestion >= this.questions.length) {
            this.endTest();
        } else {
            this.nextQuestion();
        }
    }

    protected void incorrectAnswerPressed() {
        if (this.feedbackEnabed) {
            String extraText = this.getCorrectButton().getText();
            if (extraText != null) {
                extraText = "The correct answer is " + extraText;
            }
            CudosTest.showIncorrectMessage(extraText, this, this.messageDialogIfIncorrect);
        }
        ++this.currentQuestion;
        if (this.currentQuestion >= this.questions.length) {
            this.endTest();
        } else {
            this.nextQuestion();
        }
    }

    protected void endTest() {
        CudosTest.endTest(this.name, this.correct, this.questions.length);
        this.initialiseTest();
        this.nextQuestion();
    }

    protected void nextQuestion() {
        this.questiontext.setText(this.questions[this.order[this.currentQuestion]]);
        this.questionnumber.setText("Question " + this.currentQuestion);
        this.totaltext.setText(String.valueOf(this.currentQuestion));
        int[] ansOrder = null;
        if (this.randomiseAnswers) {
            ansOrder = CudosTest.randomizeOrder(this.answerButtons.length);
        }
        int k = 0;
        while (k < this.answerButtons.length) {
            int i = this.randomiseAnswers ? ansOrder[k] : k;
            String ans = this.answers[this.order[this.currentQuestion]][k];
            if (ans.endsWith(".jpg") || ans.endsWith(".gif")) {
                this.answerButtons[i].setIcon(new ImageIcon(this.getApplet().getImage(ans)));
                this.answerButtons[i].setText("");
            } else {
                this.answerButtons[i].setText(ans);
                this.answerButtons[i].setIcon(null);
            }
            this.answerButtons[i].setActionCommand(String.valueOf(k));
            ++k;
        }
    }

    public String getExhibitName() {
        return this.name;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border2 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setBorder(this.border1);
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel4.setLayout(this.borderLayout4);
        this.exitbutton.setText("Exit");
        this.exitbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultipleChoiceTest.this.exitbutton_actionPerformed(e);
            }
        });
        this.passbutton.setText("Pass on this question");
        this.passbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultipleChoiceTest.this.passbutton_actionPerformed(e);
            }
        });
        this.questionnumber.setFont(new Font("Dialog", 1, 16));
        this.questionnumber.setText("Question 1");
        this.scoretext.setFont(this.bigFont);
        this.scoretext.setText("0");
        this.jLabel3.setFont(this.bigFont);
        this.jLabel3.setText("/");
        this.totaltext.setFont(this.bigFont);
        this.totaltext.setText("0");
        this.jPanel2.setLayout(this.borderLayout5);
        this.answerspanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(10);
        this.gridLayout1.setRows(2);
        this.gridLayout1.setVgap(10);
        this.answerspanel.setBorder(this.border2);
        this.questiontext.setFont(new Font("Serif", 0, 24));
        this.questiontext.setEditable(false);
        this.questiontext.setText("What is the");
        this.questiontext.setLineWrap(true);
        this.questiontext.setRows(3);
        this.questiontext.setWrapStyleWord(true);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jPanel5, "East");
        this.jPanel5.add((Component)this.passbutton, null);
        this.jPanel5.add((Component)this.exitbutton, null);
        this.jPanel1.add((Component)this.jPanel6, "Center");
        this.jPanel6.add((Component)this.scoretext, null);
        this.jPanel6.add((Component)this.jLabel3, null);
        this.jPanel6.add((Component)this.totaltext, null);
        this.jPanel1.add((Component)this.questionnumber, "West");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.getContentPane().add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.questiontext, null);
        this.jPanel2.add((Component)this.answerspanel, "Center");
    }

    public boolean isPassEnabled() {
        return this.passEnabled;
    }

    public void setPassEnabled(boolean passEnabled) {
        this.passEnabled = passEnabled;
        this.passbutton.setVisible(passEnabled);
    }

    public boolean isFeedbackEnabed() {
        return this.feedbackEnabed;
    }

    public void setFeedbackEnabed(boolean feedbackEnabed) {
        this.feedbackEnabed = feedbackEnabed;
        this.scoretext.setVisible(feedbackEnabed);
    }

    void exitbutton_actionPerformed(ActionEvent e) {
        this.getApplet().toChooser();
    }

    JButton getCorrectButton() {
        int cmd = this.correctAnswer[this.order[this.currentQuestion]];
        int i = 0;
        while (i < this.answerButtons.length) {
            if (this.answerButtons[i].getActionCommand().equals(String.valueOf(cmd))) {
                return this.answerButtons[i];
            }
            ++i;
        }
        return null;
    }
}

