/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

public class Matrix {
    public double[][] a;

    public Matrix() {
    }

    public Matrix(double[][] b) {
        this.a = b;
    }

    public Matrix inverse() {
        if (this.a.length == 0) {
            return null;
        }
        if (!this.isSquare()) {
            return null;
        }
        double d = this.determinant();
        if (d == 0.0) {
            return null;
        }
        Matrix m = this.a.length == 1 ? new Matrix(new double[][]{{1.0}}) : this.cofactorMatrix().transpose();
        return m.multiply(1.0 / d);
    }

    public Matrix cofactorMatrix() {
        if (!this.isSquare()) {
            return null;
        }
        double[][] b = new double[this.a.length][this.a.length];
        int i = 0;
        while (i < this.a.length) {
            int j = 0;
            while (j < this.a.length) {
                b[i][j] = (double)this.parity(i + j) * this.cofactor(i, j);
                ++j;
            }
            ++i;
        }
        return new Matrix(b);
    }

    public Matrix multiply(double f) {
        double[][] b = new double[this.a.length][this.a[0].length];
        int i = 0;
        while (i < this.a.length) {
            int j = 0;
            while (j < this.a[0].length) {
                b[i][j] = f * this.a[i][j];
                ++j;
            }
            ++i;
        }
        return new Matrix(b);
    }

    public Matrix multiply(Matrix m) {
        int p = this.a[0].length;
        if (p != m.a.length) {
            return null;
        }
        double[][] b = new double[this.a.length][m.a[0].length];
        int i = 0;
        while (i < this.a.length) {
            int j = 0;
            while (j < m.a[0].length) {
                b[i][j] = 0.0;
                int k = 0;
                while (k < p) {
                    double[] dArray = b[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.a[i][k] * m.a[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return new Matrix(b);
    }

    public Matrix transpose() {
        double[][] b = new double[this.a[0].length][this.a.length];
        int i = 0;
        while (i < this.a.length) {
            int j = 0;
            while (j < this.a[0].length) {
                b[j][i] = this.a[i][j];
                ++j;
            }
            ++i;
        }
        return new Matrix(b);
    }

    public boolean isSquare() {
        return this.a.length == this.a[0].length;
    }

    public double cofactor(int i, int j) {
        Matrix com = this.coMatrix(i, j);
        if (com == null) {
            return Double.NaN;
        }
        return com.determinant();
    }

    public Matrix coMatrix(int i, int j) {
        if (!this.isSquare()) {
            return null;
        }
        if (this.a.length == 1) {
            return null;
        }
        double[][] c = new double[this.a.length - 1][this.a.length - 1];
        int x = 0;
        while (x < c.length) {
            int y = 0;
            while (y < c.length) {
                c[x][y] = this.a[x + (x >= i ? 1 : 0)][y + (y >= j ? 1 : 0)];
                ++y;
            }
            ++x;
        }
        return new Matrix(c);
    }

    public double determinant() {
        if (!this.isSquare()) {
            return Double.NaN;
        }
        if (this.a.length < 1) {
            return 0.0;
        }
        if (this.a.length < 2) {
            return this.a[0][0];
        }
        double total = 0.0;
        int i = 0;
        while (i < this.a.length) {
            total += (double)this.parity(i) * this.a[0][i] * this.cofactor(0, i);
            ++i;
        }
        return total;
    }

    public int parity(int x) {
        return 1 - x % 2 * 2;
    }
}

