/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import com.cudos.common.CudosApplet;
import com.cudos.common.CudosExhibit;
import com.cudos.common.ProgressDialog;
import com.cudos.common.TitleBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class MainCudosApplet
extends JApplet
implements CudosApplet {
    static final String[][] pinfo = new String[][]{{"exhibit", "string", "initial exhibit classname"}};
    public static Border etched;
    public static Border raisedbevel;
    public static Border loweredbevel;
    TitleBar titleBar;
    JPanel mainPanel = new JPanel();
    public CudosExhibit content;
    private Vector stack = new Vector();
    static int iid;
    MediaTracker mt = new MediaTracker(this);
    ProgressDialog ipd = new ProgressDialog("Loading Images", "Please wait, images downloading");

    static {
        iid = 0;
    }

    public MainCudosApplet() {
        this.staticinit();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        String clsname = this.getParameter("exhibit");
        if (clsname != null) {
            int p = clsname.indexOf(58);
            if (p > 0) {
                String params = clsname.substring(p + 1);
                clsname = clsname.substring(0, p);
                this.toExhibit(clsname, params);
                return;
            }
        } else {
            clsname = "com.cudos.ModuleChooser";
        }
        this.toExhibit(clsname);
    }

    public String[][] getParameterInfo() {
        return pinfo;
    }

    public void staticinit() {
        etched = BorderFactory.createEtchedBorder();
        raisedbevel = BorderFactory.createRaisedBevelBorder();
        loweredbevel = BorderFactory.createLoweredBevelBorder();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paintText3D(Graphics2D g, String t, int x, int y) {
        g.setPaint(SystemColor.controlLtHighlight);
        g.drawString(t, x + 1, y + 1);
        g.setPaint(SystemColor.controlShadow);
        g.drawString(t, x, y);
    }

    public int getTextWidth(Graphics2D g, String t) {
        return (int)g.getFont().getStringBounds(t, 0, t.length(), g.getFontRenderContext()).getWidth();
    }

    public int getTextHeight(Graphics2D g, String t) {
        return (int)g.getFont().getStringBounds(t, 0, t.length(), g.getFontRenderContext()).getHeight();
    }

    public void paintComponentMessage(Component c, String s) {
        Graphics2D g = (Graphics2D)c.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(new Font("SansSerif", 1, 16));
        this.paintText3D(g, s, (c.getWidth() - this.getTextWidth(g, s)) / 2, (c.getHeight() - this.getTextHeight(g, s)) / 2);
    }

    public Container getMainContainer() {
        return this.mainPanel;
    }

    public CudosExhibit getExhibitContent() {
        return this.content;
    }

    private void setExhibitContent(CudosExhibit e) {
        CudosExhibit newcontent = e;
        if (newcontent != null) {
            if (this.content != null) {
                this.mainPanel.remove(this.content);
            }
            this.content = newcontent;
            this.mainPanel.add((Component)this.content, "Center");
            this.validateTree();
            this.titleBar.setTitle(this.content.getExhibitName());
            this.titleBar.repaint();
            this.content.postinit();
            this.mainPanel.repaint();
        }
    }

    private void setExhibitContent(String clsname) {
        try {
            Class<?> cls = Class.forName(clsname);
            CudosExhibit newcontent = (CudosExhibit)cls.newInstance();
            this.setExhibitContent(newcontent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setExhibitContent(String clsname, Object param) {
        try {
            Class<?> cls = Class.forName(clsname);
            Constructor<?> cn = cls.getConstructor(param.getClass());
            CudosExhibit newcontent = (CudosExhibit)cn.newInstance(param);
            this.setExhibitContent(newcontent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toChooser() {
        this.stack.remove(this.content.getClass().getName());
        String oldcls = (String)this.stack.get(this.stack.size() - 1);
        this.setExhibitContent(oldcls);
    }

    public void toExhibit(String cls) {
        this.setExhibitContent(cls);
        this.stack.add(cls);
    }

    public void toExhibit(String cls, Object param) {
        this.setExhibitContent(cls, param);
        this.stack.add(cls);
    }

    public Image getImage(String s) {
        return this.getImage(this.getCodeBase(), s);
    }

    public Image getImage(URL u, String s) {
        Image i = super.getImage(u, s);
        this.mt.addImage(i, ++iid);
        this.ipd.show();
        try {
            this.mt.waitForID(iid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ipd.hide();
        return i;
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.titleBar = new TitleBar();
        this.getContentPane().add((Component)this.titleBar, "North");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.setLayout(new BorderLayout());
    }

    public void setTitle(String s) {
        this.titleBar.setTitle(s);
    }

    public URL getResourceURL(String resource) {
        try {
            return new URL(this.getCodeBase(), resource);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTitle() {
        return this.titleBar.getTitle();
    }
}

