/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import com.cudos.common.ImageControl;
import com.cudos.common.IndexedImageListener;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.PixelGrabber;
import java.util.Random;
import java.util.Vector;

public class IndexedImageControl
extends ImageControl {
    Image index;
    IndexedImageListener listener = null;
    protected static int[] lookup = new int[]{0xC00000, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 49152, 192, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFF80FF, 0x80FFFF, 0xFFFF80};
    ImageRegion[] region = new ImageRegion[lookup.length];
    boolean regionsCreated = false;
    Random rand = new Random();
    boolean indexloaded = false;

    public boolean imageUpdate(Image i, int inf, int x, int y, int w, int h) {
        if (i == this.index && (inf & 0x20) > 0) {
            this.indexloaded = true;
            if (this.region[0] == null) {
                this.createRegions();
            }
        }
        return super.imageUpdate(i, inf, x, y, w, h);
    }

    public void createRegions() {
        int w = this.index.getWidth(this);
        int h = this.index.getHeight(this);
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(this.index, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        int i = 0;
        while (i < lookup.length) {
            this.region[i] = new ImageRegion(pix, w, h, lookup[i] + -16777216);
            ++i;
        }
        this.regionsCreated = true;
    }

    public IndexedImageControl() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Point s = IndexedImageControl.this.screenToImage(e.getPoint(), IndexedImageControl.this.index);
                int ix = s.x;
                int iy = s.y;
                int[] pix = new int[3];
                PixelGrabber pg = new PixelGrabber(IndexedImageControl.this.index, ix, iy, 1, 1, pix, 0, 1);
                try {
                    pg.grabPixels();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                if (IndexedImageControl.this.listener != null) {
                    IndexedImageControl.this.listener.indexedImageEvent(IndexedImageControl.this.lookUpPix(pix[0]));
                }
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void indexHighlight(int i, Color c, double alpha) {
        int ix = this.getImageWidth(this.index);
        int iy = this.getImageHeight(this.index);
        int searchval = lookup[i] + -16777216;
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.setColor(c);
        g.setComposite(AlphaComposite.getInstance(3, 0.2f));
        if (this.indexloaded && this.regionsCreated) {
            this.region[i].shade(g, c, alpha);
        } else if (!this.indexloaded) {
            System.out.println("Index image not loaded yet.");
        } else if (!this.regionsCreated) {
            System.out.println("Regions not created yet.");
        }
    }

    public int lookUpPix(int p) {
        int j = -1;
        int i = 0;
        while (i < lookup.length) {
            if (p == lookup[i] + -16777216) {
                j = i;
                break;
            }
            ++i;
        }
        return j;
    }

    public int getImageWidth(Image i) {
        return i.getWidth(this);
    }

    public int getImageHeight(Image i) {
        return i.getHeight(this);
    }

    public void setIndexedImageListener(IndexedImageListener l) {
        this.listener = l;
    }

    public void setIndex(Image i) {
        this.index = i;
        if (this.index.getHeight(this) >= 0) {
            this.indexloaded = true;
            this.createRegions();
        } else {
            this.indexloaded = false;
        }
    }

    public Image getIndex() {
        return this.index;
    }

    class ImageRegion {
        int[][] bounds;
        int height;

        public ImageRegion(int[] pixels, int width, int h, int colour) {
            this.height = h;
            this.bounds = new int[this.height][];
            int y = 0;
            while (y < this.height) {
                boolean inside = false;
                int currp = 0;
                Vector<Integer> b = new Vector<Integer>();
                int x = 0;
                while (x < width) {
                    currp = pixels[x + width * y];
                    if (!inside && currp == colour || inside && currp != colour) {
                        inside = !inside;
                        b.add(new Integer(x));
                    }
                    ++x;
                }
                if (inside) {
                    b.add(new Integer(width - 1));
                }
                this.bounds[y] = new int[b.size()];
                int i = 0;
                while (i < this.bounds[y].length) {
                    this.bounds[y][i] = (Integer)b.get(i);
                    ++i;
                }
                ++y;
            }
        }

        public void shade(Graphics2D g, Color c, double alpha) {
            g.setColor(c);
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha));
            int sw = 2;
            g.setStroke(new BasicStroke(sw / 2));
            int b = 0;
            int y = 0;
            while (y < this.height) {
                if (b++ % sw == 0) {
                    int xi = 0;
                    while (xi < this.bounds[y].length) {
                        Point p1 = IndexedImageControl.this.imageToScreen(new Point(this.bounds[y][xi++], y), IndexedImageControl.this.image);
                        Point p2 = IndexedImageControl.this.imageToScreen(new Point(this.bounds[y][xi], y), IndexedImageControl.this.image);
                        g.drawLine(p1.x, p1.y, p2.x, p2.y);
                        ++xi;
                    }
                }
                ++y;
            }
        }
    }
}

