/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import com.cudos.common.FormulaGraphPanel;
import evaluator.Expression;
import evaluator.MathException;
import evaluator.ParseException;
import evaluator.StackException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.Vector;

public class ImplicitExpression
extends Expression {
    private Expression zExpr;
    int width;
    int height;
    FormulaGraphPanel panel;
    int NDIV = 8;
    final int TL = 1;
    final int TR = 2;
    final int BR = 4;
    final int BL = 8;
    final int U = 1;
    final int R = 2;
    final int D = 4;
    final int L = 8;
    int[][] match = new int[][]{{1, 9}, {4, 6}, {11, 6}, {14, 9}, {10, 15}, {3, 10}, {12, 10}, {9, 5}, {6, 5}, {8, 12}, {13, 3}, {7, 12}, {2, 3}, {5, 15}};

    public ImplicitExpression(String s) throws ParseException {
        super(s);
    }

    public String toString() {
        return "0=" + this.getDefinition();
    }

    public Trace createTrace(FormulaGraphPanel p, int w, int h) {
        this.width = w;
        this.height = h;
        this.panel = p;
        CurrentImplicitData data = new CurrentImplicitData();
        this.prepareImplicitData(data, new Rectangle(0, 0, w, h));
        Trace t = this.doTrace(data);
        return t;
    }

    void prepareImplicitData(CurrentImplicitData data, Rectangle cSq) {
        int dx = cSq.width / this.NDIV;
        int dy = cSq.height / this.NDIV;
        if (dx < 1) {
            dx = 1;
        }
        if (dy < 1) {
            dy = 1;
        }
        boolean nomore = false;
        if (dx == 1 && dy == 1) {
            nomore = true;
        }
        try {
            int xs = cSq.x;
            while (xs - dx < cSq.x + cSq.width) {
                int ys = cSq.y;
                while (ys - dy < cSq.y + cSq.height) {
                    if (xs <= this.width && ys <= this.height) {
                        this.ensureC(data, xs, ys);
                        if (xs > cSq.x && ys > cSq.y && (data.q[xs][ys] != data.q[xs - dx][ys] || data.q[xs][ys] != data.q[xs][ys - dy] || data.q[xs][ys] != data.q[xs - dx][ys - dy])) {
                            if (nomore) {
                                data.edge.add(new Point(xs, ys));
                            } else {
                                this.prepareImplicitData(data, new Rectangle(xs - dx, ys - dy, dx, dy));
                            }
                        }
                    }
                    ys += dy;
                }
                xs += dx;
            }
        }
        catch (MathException ex) {
            ex.printStackTrace();
        }
        catch (StackException ex) {
            ex.printStackTrace();
        }
    }

    Trace doTrace(CurrentImplicitData data) {
        Trace t = new Trace();
        if (data.edge.size() == 0) {
            return t;
        }
        t.curr = (Point)data.edge.get(0);
        int i = 0;
        while (i < data.edge.size()) {
            Point p = (Point)data.edge.get(i);
            if (!t.e[p.x][p.y] && p.x > 0 && p.y > 0 && p.x < this.width && p.y < this.height) {
                t.gp.moveTo(p.x, p.y);
                int d = this.getMatch(this.getPattern(data, p.x, p.y));
                try {
                    this.trace(data, t, p.x, p.y, 0);
                }
                catch (StackException ex) {
                    ex.printStackTrace();
                }
                catch (MathException ex) {
                    ex.printStackTrace();
                }
            }
            ++i;
        }
        return t;
    }

    int getPattern(CurrentImplicitData data, int x, int y) {
        return (data.q[x - 1][y - 1] ? 1 : 0) + (data.q[x][y - 1] ? 2 : 0) + (data.q[x][y] ? 4 : 0) + (data.q[x - 1][y] ? 8 : 0);
    }

    void trace(CurrentImplicitData data, Trace t, int x, int y, int d) throws StackException, MathException {
        while (!t.e[x][y] && x > 0 && y > 0 && x < this.width - 1 && y < this.height - 1) {
            int dir;
            t.e[x][y] = true;
            this.ensureC(data, x, y);
            this.ensureC(data, x - 1, y);
            this.ensureC(data, x, y - 1);
            this.ensureC(data, x - 1, y - 1);
            if (!(data.c[x][y] && data.c[x - 1][y] && data.c[x][y - 1] && data.c[x - 1][y - 1])) {
                dir = d;
                return;
            }
            int patt = this.getPattern(data, x, y);
            dir = this.getMatch(patt);
            t.gp.lineTo(x, y);
            int futures = 0;
            int nd = 0;
            if ((dir & 1) > 0 && d != 4 && y > 0 && !t.e[x][y - 1]) {
                ++futures;
                nd |= 1;
            }
            if ((dir & 2) > 0 && d != 8 && x < this.width && !t.e[x + 1][y]) {
                ++futures;
                nd |= 2;
            }
            if ((dir & 4) > 0 && d != 1 && y < this.height && !t.e[x][y + 1]) {
                ++futures;
                nd |= 4;
            }
            if ((dir & 8) > 0 && d != 2 && x > 0 && !t.e[x - 1][y]) {
                ++futures;
                nd |= 8;
            }
            if (futures == 0) {
                return;
            }
            d = this.findOneBit(nd);
            if (futures > 1) {
                int nxtd = d;
                while (nd > 0) {
                    nxtd = this.findOneBit(nd ^= nxtd);
                    this.trace(data, t, x + this.dirDX(nxtd), y + this.dirDY(nxtd), nxtd);
                    t.gp.moveTo(x, y);
                }
            }
            x += this.dirDX(d);
            y += this.dirDY(d);
        }
    }

    int getMatch(int patt) {
        int i = 0;
        while (i < this.match.length) {
            if (this.match[i][0] == patt) {
                return this.match[i][1];
            }
            ++i;
        }
        return 0;
    }

    int findOneBit(int x) {
        int i = 0;
        while (i < 8) {
            if ((x & 1 << i) > 0) {
                return 1 << i;
            }
            ++i;
        }
        return 0;
    }

    int dirDX(int d) {
        return d == 8 ? -1 : (d == 2 ? 1 : 0);
    }

    int dirDY(int d) {
        return d == 1 ? -1 : (d == 4 ? 1 : 0);
    }

    void ensureC(CurrentImplicitData data, int xs, int ys) throws StackException, MathException {
        if (!data.c[xs][ys]) {
            FormulaGraphPanel.x = this.panel.xG(xs);
            FormulaGraphPanel.y = this.panel.yG(ys);
            data.q[xs][ys] = this.value() > 0.0;
            data.c[xs][ys] = true;
        }
    }

    class CurrentImplicitData {
        boolean[][] q;
        boolean[][] c;
        Vector edge = new Vector();

        CurrentImplicitData() {
            this.q = new boolean[ImplicitExpression.this.width][ImplicitExpression.this.height];
            this.c = new boolean[ImplicitExpression.this.width][ImplicitExpression.this.height];
        }
    }

    public class Trace {
        boolean[][] e;
        Point curr;
        GeneralPath gp;

        public Trace() {
            this.e = new boolean[ImplicitExpression.this.width][ImplicitExpression.this.height];
            this.gp = new GeneralPath();
        }
    }
}

