/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import com.cudos.common.IndexedImageListener;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.Vector;
import javax.swing.JComponent;

public class ImageStackControl
extends JComponent {
    Vector iCoords = new Vector();
    Vector images = new Vector();
    Vector pixels = new Vector();
    Vector loaded = new Vector();
    Vector readytoload = new Vector();
    int[] pix;
    int count = 1;
    int renderres = 200;
    public float transparency = 0.4f;
    int blocksize = 2;
    public int selection = -1;
    IndexedImageListener listener;
    Image dest;
    int readyimages = 0;
    int thick;
    int renderh;
    public double perspective = 1.0;
    boolean loading = false;

    public void paint(Graphics g_) {
        Graphics2D g = (Graphics2D)g_;
        if (this.dest != null) {
            g.drawImage(this.dest, 0, 0, this);
        } else {
            g.setColor(Color.black);
            int i = 0;
            while (i < this.loaded.size()) {
                Point[] p = (Point[])this.iCoords.get(i);
                this.drawOutline(g, p);
                ++i;
            }
        }
        if (this.selection >= 0) {
            g.setColor(Color.red);
            g.setStroke(new BasicStroke(4.0f));
            this.drawOutline(g, (Point[])this.iCoords.get(this.selection));
        }
        g.fill3DRect(0, this.getHeight() - 10, (int)(20.0 * Math.log(this.count)), 10, false);
    }

    public void drawOutline(Graphics2D g, Point[] p) {
        g.draw(new Line2D.Double(p[0], p[1]));
        g.draw(new Line2D.Double(p[1], p[3]));
        g.draw(new Line2D.Double(p[3], p[2]));
        g.draw(new Line2D.Double(p[2], p[0]));
    }

    public void setIndexedImageListener(IndexedImageListener l) {
        this.listener = l;
    }

    public ImageStackControl() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int n = ImageStackControl.this.images.size();
                ImageStackControl.this.selection = n - e.getY() / ImageStackControl.this.thick - 1;
                if (ImageStackControl.this.selection >= n) {
                    ImageStackControl.this.selection = -1;
                }
                if (ImageStackControl.this.listener != null) {
                    ImageStackControl.this.listener.indexedImageEvent(ImageStackControl.this.selection);
                }
                ImageStackControl.this.repaint();
            }
        });
    }

    public void buildGraphic() {
        if (this.dest == null) {
            this.dest = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        Graphics2D g = (Graphics2D)this.dest.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setComposite(AlphaComposite.getInstance(3, this.transparency));
        this.repositionImages();
        int c = 0;
        int i = 0;
        while (i < this.loaded.size()) {
            Point[] p = (Point[])this.iCoords.get(i);
            if (((Boolean)this.loaded.get(i)).booleanValue()) {
                int[] pix = (int[])this.pixels.get(i);
                int w = ((Image)this.images.get(i)).getWidth(this);
                int h = ((Image)this.images.get(i)).getHeight(this);
                int m = 0;
                while (m < this.renderres) {
                    ++this.count;
                    this.getGraphics().fill3DRect(0, this.getHeight() - 10, (int)(20.0 * Math.log(this.count)), 10, false);
                    int rx = p[0].x + m * (p[2].x - p[0].x) / this.renderres;
                    int ry = p[0].y + m * (p[2].y - p[0].y) / this.renderres;
                    double lx = ((double)(p[1].x - p[0].x) + (double)(m * (p[3].x - p[2].x - p[1].x + p[0].x)) / (double)this.renderres) / (double)this.renderres;
                    double ly = ((double)(p[1].y - p[0].y) + (double)(m * (p[3].y - p[2].y - p[1].y + p[0].y)) / (double)this.renderres) / (double)this.renderres;
                    int pixbase = w * (m * h / this.renderres);
                    double pixdx = (double)w / (double)this.renderres;
                    int n = 0;
                    while (n < this.renderres) {
                        c = pix[pixbase + (int)((double)n * pixdx)];
                        if ((c & 0xFF) < 240 && (c & 0xFF00) < 61440 && (c & 0xFF0000) < 0xF00000) {
                            g.setColor(new Color(c));
                            g.fillRect(rx + (int)((double)n * lx), ry + (int)((double)n * ly), this.blocksize, this.blocksize);
                        }
                        ++n;
                    }
                    ++m;
                }
            }
            ++i;
        }
        this.count = 1;
    }

    public void repositionImages() {
        int ny = this.images.size();
        this.thick = this.getHeight() * 4 / 5 / ny;
        this.renderh = (int)(this.perspective * (double)this.getHeight() / 4.0);
        int recede = (int)(50.0 / this.perspective);
        int i = 0;
        while (i < ny) {
            Point[] ps = (Point[])this.iCoords.get(i);
            int ni = ny - i - 1;
            ps[0] = new Point(recede, this.thick * ni);
            ps[1] = new Point(this.getWidth() - recede, this.thick * ni);
            ps[2] = new Point(0, this.thick * ni + this.renderh);
            ps[3] = new Point(this.getWidth(), this.thick * ni + this.renderh);
            ++i;
        }
    }

    public void addImage(Image i) {
        this.images.add(i);
        int ny = this.images.size();
        this.iCoords.add(new Point[4]);
        this.loaded.add(new Boolean(false));
        this.pixels.add(null);
        this.repositionImages();
        if (i.getWidth(this) >= 0) {
            this.readytoload.add(new Boolean(true));
            this.loadPixels(i);
        } else {
            this.readytoload.add(new Boolean(false));
        }
    }

    public void loadPixels(Image i) {
        this.loading = true;
        int j = this.images.indexOf(i);
        int w = i.getWidth(this);
        int h = i.getHeight(this);
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(i, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pixels.set(j, pix);
        this.loaded.set(j, new Boolean(true));
        if (++this.readyimages >= this.images.size()) {
            this.buildGraphic();
            this.repaint();
        } else {
            int k = 0;
            while (k < this.images.size()) {
                if (!((Boolean)this.loaded.get(k)).booleanValue() && ((Boolean)this.readytoload.get(k)).booleanValue()) {
                    this.loadPixels((Image)this.images.get(k));
                }
                ++k;
            }
        }
        this.loading = false;
    }

    public boolean imageUpdate(Image i, int inf, int x, int y, int w, int h) {
        int j = this.images.indexOf(i);
        if (inf == 32 && !((Boolean)this.loaded.get(j)).booleanValue()) {
            this.readytoload.set(j, new Boolean(true));
            if (!this.loading) {
                this.loadPixels(i);
            }
        }
        ++this.count;
        this.repaint();
        return super.imageUpdate(i, inf, x, y, w, h);
    }
}

