/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import com.cudos.common.CudosExhibit;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JComponent;

public class ImageControl
extends JComponent {
    Image image;
    boolean stretch = false;
    String swait = "Please wait, loading image...";
    int count = 0;
    boolean loaded = false;

    public ImageControl() {
        this.image = null;
    }

    public void setStretched(boolean b) {
        this.stretch = b;
    }

    public boolean getStretched() {
        return this.stretch;
    }

    public ImageControl(Image i) {
        this.setImage(i);
    }

    public void setImage(Image i) {
        this.image = i;
        if (i != null) {
            int w = this.image.getWidth(this);
            if (this.image.getWidth(this) > 0) {
                this.repaint();
                this.loaded = true;
            } else {
                this.loaded = false;
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null && this.loaded) {
            if (this.stretch) {
                g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
            } else {
                int x = this.image.getWidth(this);
                int y = this.image.getHeight(this);
                g.drawImage(this.image, (this.getWidth() - x) / 2, (this.getHeight() - y) / 2, this);
            }
        } else {
            CudosExhibit.getApplet(this).paintComponentMessage(this, this.swait);
            g.setColor(Color.blue);
            g.fill3DRect(10, this.getHeight() / 2 + 50, this.count++, 20, false);
        }
    }

    public boolean imageUpdate(Image i, int inf, int x, int y, int w, int h) {
        if (i == this.image && (inf & 0x20) > 0) {
            this.loaded = true;
            this.repaint();
        }
        return super.imageUpdate(i, inf, x, y, w, h);
    }

    public Point screenToImage(Point p, Image i) {
        if (this.stretch) {
            return new Point(p.x * i.getWidth(this) / this.getWidth(), p.y * i.getHeight(this) / this.getHeight());
        }
        return new Point(p.x - (this.getWidth() - i.getWidth(this)) / 2, p.y - (this.getHeight() - i.getHeight(this)) / 2);
    }

    public Point imageToScreen(Point p, Image i) {
        if (this.stretch) {
            return new Point(p.x * this.getWidth() / i.getWidth(this), p.y * this.getWidth() / i.getWidth(this));
        }
        return new Point(p.x + (this.getWidth() - i.getWidth(this)) / 2, p.y + (this.getHeight() - i.getHeight(this)) / 2);
    }
}

