/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLMessagePane
extends JPanel
implements HyperlinkListener {
    protected JOptionPane op;
    protected JEditorPane ed;

    public HTMLMessagePane(URL htmlResource) {
        this.setLayout(new BorderLayout());
        try {
            this.ed = new JEditorPane(htmlResource);
        }
        catch (IOException x) {
            this.ed = new JEditorPane("text/plain", "Error loading file " + htmlResource + "\n" + x.getMessage());
            x.printStackTrace();
        }
        JScrollPane sp = new JScrollPane(this.ed);
        this.ed.setEditable(false);
        this.ed.addHyperlinkListener(this);
        this.op = new JOptionPane(sp, 1, -1);
        this.add((Component)this.op, "Center");
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    pane.setPage(e.getURL());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static void showDialog(URL htmlResource, String title, Component parent) {
        final JDialog d = new JDialog();
        HTMLMessagePane mp = new HTMLMessagePane(htmlResource);
        d.getContentPane().add(mp);
        d.pack();
        d.setSize(400, 300);
        d.setLocationRelativeTo(parent);
        mp.op.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                d.hide();
            }
        });
        d.setTitle(title);
        d.show();
    }
}

