/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

public class GraphPaper
extends JPanel {
    protected double minx;
    protected double maxx;
    protected double majorx;
    protected double minorx;
    protected double miny;
    protected double maxy;
    protected double majory;
    protected double minory;
    public boolean highlightAxis = true;
    boolean drawLabels = false;
    protected Color labelColour = null;

    public GraphPaper() {
        this.setFont(new Font("Dialog", 0, 10));
        this.setForeground(Color.green);
        this.setBackground(Color.black);
        this.miny = 0.0;
        this.minx = 0.0;
        this.maxy = 100.0;
        this.maxx = 100.0;
        this.majory = 50.0;
        this.majorx = 50.0;
        this.minory = 10.0;
        this.minorx = 10.0;
    }

    public void paint(Graphics g) {
        super.paint(g);
        double dx = this.maxx - this.minx;
        double dy = this.maxy - this.miny;
        g.setColor(this.getMidColour());
        this.drawg(g, (double)((int)(this.minx / this.minorx)) * this.minorx, 1 + (int)(dx / this.minorx), this.minorx, false, false);
        this.drawg(g, (double)((int)(this.miny / this.minory)) * this.minory, 1 + (int)(dy / this.minory), this.minory, true, false);
        g.setColor(this.getForeground());
        this.drawg(g, (double)((int)(this.minx / this.majorx)) * this.majorx, 2 + (int)(dx / this.majorx), this.majorx, false, this.drawLabels);
        this.drawg(g, (double)((int)(this.miny / this.majory)) * this.majory, 2 + (int)(dy / this.majory), this.majory, true, this.drawLabels);
        if (this.highlightAxis) {
            g.setColor(this.getAxisColour());
            g.drawLine(0, this.yS(0.0), this.getWidth(), this.yS(0.0));
            g.drawLine(this.xS(0.0), 0, this.xS(0.0), this.getHeight());
        }
    }

    public Color getMidColour() {
        Color f = this.getForeground();
        Color b = this.getBackground();
        return new Color((f.getRed() + b.getRed()) / 2, (f.getGreen() + b.getGreen()) / 2, (f.getBlue() + b.getBlue()) / 2);
    }

    public Color getAxisColour() {
        Color f = this.getForeground();
        Color b = this.getBackground();
        int d = f.getRed() + f.getGreen() + f.getBlue() - (b.getRed() + b.getGreen() + b.getBlue());
        if (d > 0) {
            return f.brighter().brighter();
        }
        return f.darker().darker();
    }

    public void setXRange(double minimum, double maximum) {
        this.minx = minimum;
        this.maxx = maximum;
        double b = this.tenths(this.maxx - this.minx);
        int nx = (int)((this.maxx - this.minx) / b);
        this.majorx = b;
        this.minorx = b / 5.0;
        this.minx = this.majorx * (double)((int)(this.minx / this.majorx));
        System.out.println("x[" + this.minx + "," + this.maxx + "]d" + this.majorx);
    }

    public void setYRange(double minimum, double maximum) {
        this.miny = minimum;
        this.maxy = maximum;
        double b = this.tenths(this.maxy - this.miny);
        int ny = (int)((this.maxx - this.minx) / b);
        this.majory = b;
        this.minory = b / 5.0;
        this.miny = this.majory * (double)((int)(this.miny / this.majory));
        System.out.println("y[" + this.miny + "," + this.maxy + "]d" + this.majory);
    }

    public void recalculateTicks() {
        double b = this.tenths(this.maxy - this.miny);
        int ny = (int)((this.maxx - this.minx) / b);
        if (ny == 0) {
            ny = 1;
        }
        this.majory = b;
        this.minory = b / 5.0;
        b = this.tenths(this.maxx - this.minx);
        int nx = (int)((this.maxx - this.minx) / b);
        if (nx == 0) {
            nx = 1;
        }
        this.majorx = b;
        this.minorx = b / 5.0;
    }

    public void drawLine(Graphics g, double x1, double y1, double x2, double y2) {
        g.drawLine(this.xS(x1), this.yS(y1), this.xS(x2), this.yS(y2));
    }

    public Point toScreen(Point2D p) {
        return new Point(this.xS(p.getX()), this.yS(p.getY()));
    }

    public Point2D toGraph(Point p) {
        return new Point2D.Double(this.xG(p.x), this.yG(p.y));
    }

    public void setDrawLabels(boolean d) {
        this.drawLabels = d;
        this.repaint();
    }

    public boolean getDrawLabels() {
        return this.drawLabels;
    }

    public double getMajorX() {
        return this.majorx;
    }

    public void setMajorX(double d) {
        this.majorx = d;
        this.repaint();
    }

    public double getMajorY() {
        return this.majory;
    }

    public void setMajorY(double d) {
        this.majory = d;
        this.repaint();
    }

    double tenths(double a) {
        int r = (int)Math.floor(Math.log(a) / Math.log(10.0));
        return Math.pow(10.0, r);
    }

    void drawg(Graphics g, double low, int n, double dist, boolean horz, boolean labels) {
        if (horz) {
            int i = 0;
            while (i < n) {
                double yg = low + dist * (double)i;
                int y = this.yS(yg);
                g.drawLine(0, y, this.getWidth(), y);
                if (labels) {
                    g.drawString(this.tostring(yg, this.majory), 0, y);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                double xg = low + dist * (double)i;
                int x = this.xS(xg);
                g.drawLine(x, 0, x, this.getHeight());
                if (labels) {
                    g.drawString(this.tostring(xg, this.majorx), x, this.getHeight() - 10);
                }
                ++i;
            }
        }
    }

    String tostring(double a, double major) {
        a = (double)((int)(100.0 * a)) / 100.0;
        if (major > 10.0) {
            return String.valueOf((int)a);
        }
        return String.valueOf(a);
    }

    public int xS(double xG) {
        return (int)((double)this.getWidth() * (xG - this.minx) / (this.maxx - this.minx));
    }

    public int yS(double yG) {
        return (int)((double)this.getHeight() * (1.0 - (yG - this.miny) / (this.maxy - this.miny)));
    }

    public double xG(double xS) {
        return xS / (double)this.getWidth() * (this.maxx - this.minx) + this.minx;
    }

    public double yG(double yS) {
        return (1.0 - yS / (double)this.getHeight()) * (this.maxy - this.miny) + this.miny;
    }

    public Color getLabelColour() {
        return this.labelColour;
    }

    public void setLabelColour(Color labelColour) {
        this.labelColour = labelColour;
    }
}

