/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import com.cudos.common.GraphableComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GraphPanel
extends JPanel {
    JPanel jPanel1 = new JPanel();
    JPanel graphpane = new JPanel(){

        public void paint(Graphics g_) {
            super.paint(g_);
            Graphics2D g = (Graphics2D)g_;
            double dx = (double)this.getWidth() / 180.0;
            int i = 0;
            while (i < GraphPanel.this.values.length) {
                g.setColor(colors[i % colors.length]);
                int zh = (int)((double)this.getHeight() * (1.0 - GraphPanel.this.zero[i] * GraphPanel.this.scale[i]));
                g.drawLine(0, zh, this.getWidth(), zh);
                int x = 1;
                while (x < GraphPanel.this.posX) {
                    if (GraphPanel.this.values[i][x - 1] != Double.NaN && GraphPanel.this.values[i][x] != Double.NaN) {
                        g.drawLine((int)(dx * (double)(x - 1)), (int)((double)this.getHeight() * GraphPanel.this.values[i][x - 1]), (int)(dx * (double)x), (int)((double)this.getHeight() * GraphPanel.this.values[i][x]));
                    }
                    ++x;
                }
                ++i;
            }
        }
    };
    public static final Color[] colors = new Color[]{Color.red, Color.yellow, Color.green, Color.cyan, Color.white, Color.magenta, Color.orange, Color.pink, Color.gray, Color.blue};
    public double[][] values;
    public double[] scale;
    public double[] zero;
    int posX;
    Vector components = new Vector();
    Border border1;
    BorderLayout borderLayout1 = new BorderLayout();
    final int dwidth = 180;
    BorderLayout borderLayout2 = new BorderLayout();

    public void tick() {
        if (this.values.length > 0) {
            int i = 0;
            while (i < this.components.size()) {
                GraphableComponent gc = (GraphableComponent)this.components.get(i);
                this.values[i][this.posX] = 1.0 - (gc.getGraphableValue() + this.zero[i]) * this.scale[i];
                ++i;
            }
            ++this.posX;
            if (this.posX >= this.values[0].length) {
                this.reset();
            }
        }
        this.graphpane.repaint();
    }

    public void setComponents(Vector c) {
        this.components.removeAllElements();
        Enumeration e = c.elements();
        while (e.hasMoreElements()) {
            Object cc = e.nextElement();
            if (!(cc instanceof GraphableComponent)) continue;
            this.components.add(cc);
            ((GraphableComponent)cc).setColour(colors[this.components.indexOf(cc)]);
        }
        this.reset();
    }

    public void reset() {
        this.posX = 0;
        this.zero = new double[this.components.size()];
        this.scale = new double[this.components.size()];
        this.values = new double[this.components.size()][180];
        int i = 0;
        while (i < this.components.size()) {
            GraphableComponent gc = (GraphableComponent)this.components.get(i);
            this.zero[i] = -gc.getGraphableMin();
            this.scale[i] = 1.0 / (gc.getGraphableMax() + this.zero[i]);
            ++i;
        }
        this.graphpane.repaint();
    }

    public GraphPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reset();
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.graphpane.setBackground(Color.black);
        this.graphpane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                GraphPanel.this.graphpane_mouseClicked(e);
            }
        });
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.setLayout(this.borderLayout1);
        this.setLayout(this.borderLayout2);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.graphpane, "Center");
    }

    void graphpane_mouseClicked(MouseEvent e) {
        this.reset();
    }
}

