/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class FunctionGraphPanel
extends JPanel {
    JPanel graph = new JPanel(){

        public void paint(Graphics g_) {
            FunctionGraphPanel.this.i.xzero = this.getWidth() / 2;
            FunctionGraphPanel.this.i.yzero = this.getHeight() / 2;
            super.paint(g_);
            Graphics2D g = (Graphics2D)g_;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(Color.gray);
            g.drawLine(0, FunctionGraphPanel.this.i.yzero, this.getWidth(), FunctionGraphPanel.this.i.yzero);
            g.drawLine(FunctionGraphPanel.this.i.xzero, 0, FunctionGraphPanel.this.i.xzero, this.getHeight());
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.green);
            int last = this.getVH(0);
            int i = 0;
            while (i < this.getWidth()) {
                int n = last;
                last = this.getVH(i);
                g.drawLine(i - 1, n, i, last);
                ++i;
            }
            g.setColor(Color.white);
            Enumeration e = FunctionGraphPanel.this.i.nodes.elements();
            while (e.hasMoreElements()) {
                Point p = (Point)e.nextElement();
                g.fillOval(p.x - FunctionGraphPanel.this.i.handleradius, p.y - FunctionGraphPanel.this.i.handleradius, 2 * FunctionGraphPanel.this.i.handleradius, 2 * FunctionGraphPanel.this.i.handleradius);
            }
        }

        public int getVH(int x) {
            double yf = FunctionGraphPanel.this.i.function(FunctionGraphPanel.this.g2fx(x));
            if (Double.isNaN(yf)) {
                return 0;
            }
            return FunctionGraphPanel.this.f2gy(FunctionGraphPanel.this.lim(yf, -1000.0, 1000.0));
        }
    };
    JLabel jLabel1 = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jLabel2 = new JLabel();
    JRadioButton linear = new JRadioButton();
    JRadioButton sigmoid = new JRadioButton();
    ButtonGroup bg = new ButtonGroup();
    JPanel jPanel1 = new JPanel();
    Border border1;
    transient int nodedrag = -1;
    GraphInfo i = new GraphInfo();

    void nodesChange() {
        Vector nodes = this.i.nodes;
        if (this.linear.isSelected()) {
            if (nodes.size() > 1) {
                Point n1 = (Point)nodes.get(0);
                Point n2 = (Point)nodes.get(1);
                this.i.a = (this.g2fy(n2.y) - this.g2fy(n1.y)) / (this.g2fx(n2.x) - this.g2fx(n1.x));
                this.i.a = this.lim(this.i.a, -1000.0, 1000.0);
                this.i.b = this.g2fy(n1.y) - this.i.a * this.g2fx(n1.x);
            }
        } else if (this.sigmoid.isSelected() && nodes.size() > 1) {
            Point n1 = (Point)nodes.get(0);
            Point n2 = (Point)nodes.get(1);
            this.i.a = 2.0 / (this.g2fx(n2.x) - this.g2fx(n1.x));
            this.i.b = -this.i.a * this.g2fx(n1.x) - 1.0;
            this.i.c = (this.g2fy(n2.y) - this.g2fy(n1.y)) / (2.0 * Math.atan(1.0));
            this.i.d = this.i.c * Math.atan(1.0) + this.g2fy(n1.y);
        }
    }

    double g2fx(int xc) {
        return (double)(xc - this.i.xzero) * this.i.fscale / (double)this.graph.getWidth();
    }

    double g2fy(int yc) {
        return (double)(this.i.yzero - yc) * this.i.fscale / (double)this.graph.getHeight();
    }

    int f2gx(double xf) {
        return (int)(xf * (double)this.graph.getWidth() / this.i.fscale) + this.i.xzero;
    }

    int f2gy(double yf) {
        return this.i.yzero - (int)(yf * (double)this.graph.getHeight() / this.i.fscale);
    }

    public double lim(double a, double min, double max) {
        return a > max ? max : (a < min ? min : a);
    }

    public FunctionGraphPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.i.nodes.add(new Point(10, 10));
        this.i.nodes.add(new Point(30, 30));
        this.nodesChange();
        this.graph.repaint();
        this.graph.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                FunctionGraphPanel.this.nodedrag = FunctionGraphPanel.this.i.getNodeAt(e.getPoint());
            }

            public void mouseReleased(MouseEvent e) {
                FunctionGraphPanel.this.nodedrag = -1;
            }
        });
        this.graph.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (FunctionGraphPanel.this.nodedrag >= 0 && FunctionGraphPanel.this.graph.getWidth() > e.getX() && FunctionGraphPanel.this.graph.getHeight() > e.getY() && e.getX() > 0 && e.getY() > 0) {
                    Point p = (Point)FunctionGraphPanel.this.i.nodes.get(FunctionGraphPanel.this.nodedrag);
                    p.setLocation(e.getPoint());
                    FunctionGraphPanel.this.nodesChange();
                    FunctionGraphPanel.this.graph.repaint();
                }
            }
        });
        this.graph.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                FunctionGraphPanel.this.nodesChange();
                FunctionGraphPanel.this.repaint();
            }
        });
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93)), BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.graph.setPreferredSize(new Dimension(100, 100));
        this.graph.setBackground(Color.black);
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.setPreferredSize(new Dimension(125, 140));
        this.jPanel1.setLayout(this.borderLayout1);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setHorizontalTextPosition(4);
        this.jLabel1.setText("Input");
        this.jLabel2.setText("Output");
        this.linear.setText("Linear");
        this.linear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionGraphPanel.this.changetype(e);
            }
        });
        this.sigmoid.setText("Sigmoid");
        this.sigmoid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionGraphPanel.this.changetype(e);
            }
        });
        this.linear.setSelected(true);
        this.setPreferredSize(new Dimension(150, 270));
        this.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.graph, "Center");
        this.jPanel1.add((Component)this.jLabel1, "South");
        this.jPanel1.add((Component)this.jLabel2, "North");
        this.add((Component)this.linear, null);
        this.add((Component)this.sigmoid, null);
        this.bg.add(this.linear);
        this.bg.add(this.sigmoid);
    }

    void changetype(ActionEvent e) {
        if (this.linear.isSelected()) {
            this.i.type = 0;
        } else if (this.sigmoid.isSelected()) {
            this.i.type = 1;
        }
        this.nodesChange();
        this.graph.repaint();
    }

    public void setInfo(Object o) {
        if (o instanceof GraphInfo) {
            this.i = (GraphInfo)o;
            switch (this.i.type) {
                case 0: {
                    this.linear.setSelected(true);
                    break;
                }
                case 1: {
                    this.sigmoid.setSelected(true);
                }
            }
        }
        this.repaint();
    }

    public Object getInfo() {
        return this.i;
    }

    public double function(double a) {
        return this.i.function(a);
    }

    class GraphInfo
    implements Serializable {
        static final int LINEAR = 0;
        static final int SIGMOID = 1;
        int type;
        double fscale = 4.0;
        int handleradius = 4;
        int xzero;
        int yzero;
        double a;
        double b;
        double c;
        double d;
        public Vector nodes = new Vector();

        GraphInfo() {
        }

        public int getNodeAt(Point p) {
            int i = 0;
            while (i < this.nodes.size()) {
                if (p.distance((Point)this.nodes.get(i)) < (double)this.handleradius) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public double function(double x) {
            if (FunctionGraphPanel.this.linear.isSelected()) {
                return FunctionGraphPanel.this.i.a * x + FunctionGraphPanel.this.i.b;
            }
            if (FunctionGraphPanel.this.sigmoid.isSelected()) {
                return FunctionGraphPanel.this.i.c * Math.atan(FunctionGraphPanel.this.i.a * x + FunctionGraphPanel.this.i.b) + FunctionGraphPanel.this.i.d;
            }
            return 0.0;
        }
    }
}

