/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class FourierMembrane
extends JPanel
implements Runnable,
MouseMotionListener {
    public String text = "Basilar Membrane (Fourier Analysis)";
    public double k = 1.0;
    public double damp = 0.9;
    public int timer = 30;
    private int N = 100;
    private double[] x;
    private double[] dx;
    private double[] av;
    int ox;

    public FourierMembrane() {
        this.setup();
        this.addMouseMotionListener(this);
        this.setBackground(Color.black);
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stimulate(double d) {
        int i = 0;
        while (i < this.N) {
            int n = i++;
            this.dx[n] = this.dx[n] + d;
        }
    }

    public void setN(int nn) {
        nn = this.N;
        this.setup();
    }

    public int getN() {
        return this.N;
    }

    private void setup() {
        this.x = new double[this.N];
        this.dx = new double[this.N];
        this.av = new double[this.N];
    }

    public void paint(Graphics g) {
        super.paint(g);
        int w = this.getSize().width;
        int mid = this.getSize().height / 2;
        int i = 0;
        while (i < this.N) {
            g.setColor(new Color(this.tocol(Math.sin((double)i / (double)this.N)), this.tocol(Math.cos((double)i / (double)this.N)), this.tocol(this.x[i] / (double)mid)));
            g.drawLine(i * w / this.N, mid, i * w / this.N, mid + (int)this.x[i]);
            g.fillOval(i * w / this.N, mid + (int)this.x[i], 6, 6);
            if (i != 0) {
                g.drawLine((i - 1) * w / this.N, mid - (int)(this.av[i - 1] * 0.05), i * w / this.N, mid - (int)(this.av[i] * 0.05));
            }
            ++i;
        }
        g.setColor(Color.red);
        g.setFont(new Font("Arial", 0, 12));
        g.drawString(this.text, 5, 30);
    }

    private int tocol(double a) {
        if ((a = 127.0 + 127.0 * a) > 255.0) {
            return 255;
        }
        if (a < 0.0) {
            return 0;
        }
        return (int)a;
    }

    void tick() {
        int i = 0;
        while (i < this.N) {
            int n = i;
            this.x[n] = this.x[n] + this.dx[i];
            int n2 = i;
            this.dx[n2] = this.dx[n2] - this.k * this.x[i] * (double)i / (double)this.N;
            int n3 = i;
            this.dx[n3] = this.dx[n3] * this.damp;
            this.av[i] = (this.av[i] + Math.abs(this.x[i])) * this.damp;
            ++i;
        }
    }

    public void run() {
        while (true) {
            this.tick();
            this.repaint();
            try {
                Thread.sleep(this.timer);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int nx = e.getX();
        this.stimulate(nx - this.ox);
        this.ox = nx;
    }
}

