/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import com.cudos.common.GraphPaper;
import com.cudos.common.ImplicitExpression;
import com.cudos.common.ParametricExpression;
import com.cudos.common.PolarExpression;
import com.cudos.function.DataPanel;
import evaluator.Expression;
import evaluator.MathException;
import evaluator.ObjectPath;
import evaluator.ParseException;
import evaluator.StackException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class FormulaGraphPanel
extends GraphPaper {
    private Expression yExpr;
    public Vector expressions = new Vector();
    private Color lineColour = Color.yellow;
    int POLAR_POINTS = 600;
    int PARAMETRIC_POINTS = 600;
    int SCREEN_MAX = 1600;
    public static double x;
    public static double y;
    public static double t;
    public Point2D displayPoint;
    public Component displayPointComponent;
    boolean drawingData;
    DataPanel dataPanel;
    protected MouseInputListener ml;
    Color[] colours;
    Color dataPointColour;
    private Vector dataPoints;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FormulaGraphPanel() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Math");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ObjectPath.appendRoot(clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("evaluator.MathExtra");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ObjectPath.appendRoot(clazz2);
        ObjectPath.appendRoot(this);
        this.drawingData = false;
        this.ml = new MouseInputAdapter(){
            Point op;

            public void mouseClicked(MouseEvent e) {
                if (FormulaGraphPanel.this.drawingData) {
                    FormulaGraphPanel.this.dataPanel.addDataPoint(FormulaGraphPanel.this.xG(e.getX()), FormulaGraphPanel.this.yG(e.getY()));
                } else if (e.getButton() != 1) {
                    new SmoothZoomer(1.5, FormulaGraphPanel.this.toGraph(e.getPoint()));
                } else {
                    new SmoothZoomer(0.6666666666666666, FormulaGraphPanel.this.toGraph(e.getPoint()));
                }
            }

            public void mousePressed(MouseEvent e) {
                this.op = e.getPoint();
            }

            public void mouseDragged(MouseEvent e) {
                Point p = e.getPoint();
                int dx = p.x - this.op.x;
                int dy = p.y - this.op.y;
                FormulaGraphPanel.this.translate(-dx, -dy);
                this.op = p;
            }

            public void mouseMoved(MouseEvent e) {
                FormulaGraphPanel.this.displayPoint = FormulaGraphPanel.this.toGraph(e.getPoint());
                if (FormulaGraphPanel.this.displayPointComponent != null) {
                    FormulaGraphPanel.this.displayPointComponent.repaint();
                }
            }
        };
        this.colours = new Color[]{new Color(96, 128, 160)};
        this.dataPointColour = Color.red;
        this.dataPoints = new Vector();
        this.addMouseListener(this.ml);
        this.addMouseMotionListener(this.ml);
    }

    public void paint(Graphics g) {
        super.paint(g);
        int i = 0;
        while (i < this.expressions.size()) {
            Expression expr = (Expression)this.expressions.get(i);
            if (expr == null) {
                return;
            }
            if (expr == this.yExpr) {
                g.setColor(this.lineColour);
            } else {
                g.setColor(this.getLineColour(i));
            }
            ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (expr instanceof PolarExpression) {
                this.polarGraph(g, (PolarExpression)expr);
            } else if (expr instanceof ParametricExpression) {
                this.parametricGraph(g, (ParametricExpression)expr);
            } else if (expr instanceof ImplicitExpression) {
                this.implicitGraph(g, (ImplicitExpression)expr);
            } else {
                this.yGraph(g, expr);
            }
            ++i;
        }
        this.plotDataPoints(g);
    }

    void polarGraph(Graphics g, PolarExpression expr) {
        double tmin = -Math.PI;
        double tmax = Math.PI;
        try {
            tmin = new Expression(expr.tMinimum).value();
            tmax = new Expression(expr.tMaximum).value();
        }
        catch (StackException stackException) {
        }
        catch (MathException e) {
            tmin = -1.0;
            tmax = 1.0;
        }
        double oxg = Double.NaN;
        double oyg = Double.NaN;
        double delta = (tmax - tmin) / (double)this.POLAR_POINTS;
        int ox = 0;
        int oy = 0;
        double theta = tmin;
        while (theta < tmax) {
            try {
                t = theta;
                double r = expr.getR();
                double xg = r * Math.cos(t);
                double yg = r * Math.sin(t);
                int x = this.xS(xg);
                int y = this.yS(yg);
                if (!(Double.isNaN(oxg) || Double.isNaN(oyg) || Double.isNaN(xg) || Double.isNaN(yg) || Math.abs(x) >= this.SCREEN_MAX || Math.abs(y) >= this.SCREEN_MAX || Math.abs(ox) >= this.SCREEN_MAX || Math.abs(oy) >= this.SCREEN_MAX)) {
                    g.drawLine(ox, oy, x, y);
                }
                ox = x;
                oy = y;
                oxg = xg;
                oyg = yg;
            }
            catch (MathException mathException) {
            }
            catch (StackException stackException) {
                // empty catch block
            }
            theta += delta;
        }
    }

    void parametricGraph(Graphics g, ParametricExpression expr) {
        double tmin = -2.0;
        double tmax = 2.0;
        try {
            tmin = new Expression(expr.tMinimum).value();
            tmax = new Expression(expr.tMaximum).value();
        }
        catch (StackException stackException) {
        }
        catch (MathException e) {
            tmin = -1.0;
            tmax = 1.0;
        }
        double oxg = Double.NaN;
        double oyg = Double.NaN;
        double delta = (tmax - tmin) / (double)this.PARAMETRIC_POINTS;
        int ox = 0;
        int oy = 0;
        double theta = tmin;
        while (theta < tmax) {
            try {
                t = theta;
                double xg = expr.getX();
                double yg = expr.getY();
                int x = this.xS(xg);
                int y = this.yS(yg);
                if (!(Double.isNaN(oxg) || Double.isNaN(oyg) || Double.isNaN(xg) || Double.isNaN(yg) || Math.abs(x) >= this.SCREEN_MAX || Math.abs(y) >= this.SCREEN_MAX || Math.abs(ox) >= this.SCREEN_MAX || Math.abs(oy) >= this.SCREEN_MAX)) {
                    g.drawLine(ox, oy, x, y);
                }
                ox = x;
                oy = y;
                oxg = xg;
                oyg = yg;
            }
            catch (MathException mathException) {
            }
            catch (StackException stackException) {
                // empty catch block
            }
            theta += delta;
        }
    }

    void yGraph(Graphics g, Expression expr) {
        int ox = 0;
        int oy = 0;
        double oyg = Double.NaN;
        int xs = 0;
        while (xs < this.getWidth()) {
            double xg;
            x = xg = this.xG(xs);
            int ys = oy;
            try {
                double yg = expr.value();
                ys = this.yS(yg);
                if (!Double.isNaN(yg) && !Double.isNaN(oyg) && Math.abs(ys) < this.SCREEN_MAX && Math.abs(oy) < this.SCREEN_MAX) {
                    g.drawLine(ox, oy, xs, ys);
                }
                oyg = yg;
            }
            catch (MathException mathException) {
            }
            catch (StackException stackException) {
                // empty catch block
            }
            ox = xs++;
            oy = ys;
        }
    }

    void implicitGraph(Graphics g, ImplicitExpression expr) {
        ImplicitExpression.Trace t = expr.createTrace(this, this.getWidth(), this.getHeight());
        ((Graphics2D)g).draw(t.gp);
    }

    public Color getLineColour() {
        return this.lineColour;
    }

    public void setLineColour(Color lineColour) {
        this.lineColour = lineColour;
    }

    public void setExpression(String e) throws ParseException {
        this.expressions.remove(this.yExpr);
        this.yExpr = new Expression(e);
        this.expressions.add(this.yExpr);
        this.repaint();
    }

    public void setExpression(Expression e) {
        this.expressions.remove(this.yExpr);
        this.yExpr = e;
        this.expressions.add(e);
        this.repaint();
    }

    public Expression getExpression() {
        return this.yExpr;
    }

    public void selectExpression(int i) {
        this.yExpr = (Expression)this.expressions.get(i);
        this.repaint();
    }

    public void zoom(double scale, Point2D p) {
        double rx = (this.maxx - this.minx) * scale / 2.0;
        double ry = (this.maxy - this.miny) * scale / 2.0;
        this.minx = p.getX() - rx;
        this.maxx = p.getX() + rx;
        this.miny = p.getY() - ry;
        this.maxy = p.getY() + ry;
        this.recalculateTicks();
        this.repaint();
    }

    public void zoom(double scale, double x, double y) {
        this.zoom(scale, new Point2D.Double(x, y));
    }

    public void translate(int x, int y) {
        double dx = this.xG(x) - this.minx;
        double dy = this.yG(this.getHeight() - y) - this.miny;
        this.minx += dx;
        this.maxx += dx;
        this.miny -= dy;
        this.maxy -= dy;
        this.repaint();
    }

    public void startDrawData(DataPanel p) {
        this.dataPanel = p;
        this.drawingData = true;
    }

    public void stopDrawData() {
        this.drawingData = false;
    }

    public Color getLineColour(int i) {
        return this.colours[i % this.colours.length];
    }

    public void setDataPoints(Vector v) {
        this.dataPoints = v;
        this.repaint();
    }

    public Vector getDataPoints() {
        return this.dataPoints;
    }

    public void plotDataPoints(Graphics g) {
        if (this.dataPoints == null) {
            return;
        }
        g.setColor(this.dataPointColour);
        int i = 0;
        while (i < this.dataPoints.size()) {
            Point2D.Double p = (Point2D.Double)this.dataPoints.get(i);
            int x = this.xS(p.getX());
            int y = this.yS(p.getY());
            g.drawLine(x, y, x + 1, y + 1);
            ++i;
        }
    }

    class SmoothZoomer {
        double N = 6.0;
        double fraction;
        double dcx;
        double dcy;
        Point2D direction;
        int n = 0;
        Timer timer = new Timer(50, new ActionListener(this){
            final /* synthetic */ SmoothZoomer this$1;
            {
                this.this$1 = smoothZoomer;
            }

            public void actionPerformed(ActionEvent e) {
                this.this$1.direction = new Point2D.Double((SmoothZoomer.access$0((SmoothZoomer)this.this$1).maxx + SmoothZoomer.access$0((SmoothZoomer)this.this$1).minx) / 2.0 + this.this$1.dcx * 1.0, (SmoothZoomer.access$0((SmoothZoomer)this.this$1).maxy + SmoothZoomer.access$0((SmoothZoomer)this.this$1).miny) / 2.0 + this.this$1.dcy * 1.0);
                SmoothZoomer.access$0(this.this$1).zoom(this.this$1.fraction, this.this$1.direction);
                ++this.this$1.n;
                if ((double)this.this$1.n >= this.this$1.N) {
                    this.this$1.timer.stop();
                }
            }
        });

        public SmoothZoomer(double scale, Point2D p) {
            this.fraction = Math.pow(scale, 1.0 / this.N);
            this.dcx = (p.getX() - (FormulaGraphPanel.this.maxx + FormulaGraphPanel.this.minx) / 2.0) / this.N;
            this.dcy = (p.getY() - (FormulaGraphPanel.this.maxy + FormulaGraphPanel.this.miny) / 2.0) / this.N;
            this.timer.start();
        }

        static /* synthetic */ FormulaGraphPanel access$0(SmoothZoomer smoothZoomer) {
            return smoothZoomer.FormulaGraphPanel.this;
        }
    }
}

