/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import com.cudos.common.ImplicitExpression;
import com.cudos.common.ParametricExpression;
import com.cudos.common.PolarExpression;
import evaluator.Expression;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class ExpressionPanel
extends JPanel {
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JRadioButton ybutton = new JRadioButton();
    private JRadioButton parametricButton = new JRadioButton();
    private JRadioButton polarButton = new JRadioButton();
    JRadioButton implicitButton = new JRadioButton();
    private JPanel panel = new JPanel();
    private ButtonGroup bg = new ButtonGroup();
    private Box box = Box.createHorizontalBox();
    private JTextField formula1 = new JTextField();
    private JTextField formula2 = new JTextField();
    private BorderLayout borderLayout2 = new BorderLayout();
    private Component component1;
    private JPanel range = new JPanel();
    private JTextField tmax = new JTextField();
    private JLabel jLabel1 = new JLabel();
    private JTextField tmin = new JTextField();
    private GridLayout gridLayout1 = new GridLayout();
    private Border border1;
    JRadioButton[] typeRadios = new JRadioButton[]{this.ybutton, this.parametricButton, this.polarButton, this.implicitButton};
    String[] typeNames = new String[]{"Simple", "Parametric", "Polar", "Implicit"};
    ActionListener al = null;

    String getNameOfRadio(JRadioButton r) {
        int i = 0;
        while (i < this.typeRadios.length) {
            if (this.typeRadios[i] == r) {
                return this.typeNames[i];
            }
            ++i;
        }
        return null;
    }

    public ExpressionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bg.add(this.ybutton);
        this.bg.add(this.parametricButton);
        this.bg.add(this.polarButton);
        this.bg.add(this.implicitButton);
    }

    private void jbInit() throws Exception {
        this.component1 = Box.createHorizontalStrut(8);
        this.border1 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.setLayout(this.borderLayout1);
        this.ybutton.setFont(new Font("Serif", 3, 14));
        this.ybutton.setSelected(true);
        this.ybutton.setText("y(x)");
        this.ybutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionPanel.this.radio(e);
            }
        });
        this.parametricButton.setFont(new Font("Serif", 3, 14));
        this.parametricButton.setText("x(t), y(t)");
        this.parametricButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionPanel.this.radio(e);
            }
        });
        this.implicitButton.setFont(new Font("Serif", 3, 14));
        this.implicitButton.setText("f(x,y)=0");
        this.implicitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionPanel.this.radio(e);
            }
        });
        this.polarButton.setFont(new Font("Serif", 3, 14));
        this.polarButton.setText("r(t)");
        this.polarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionPanel.this.radio(e);
            }
        });
        this.formula1.setFont(new Font("SansSerif", 1, 16));
        this.formula1.setColumns(18);
        this.formula1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionPanel.this.formula1_actionPerformed(e);
            }
        });
        this.formula1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionPanel.this.formula1_actionPerformed(e);
            }
        });
        this.formula1.setColumns(18);
        this.formula1.setFont(new Font("SansSerif", 1, 16));
        this.formula2.setFont(new Font("SansSerif", 1, 16));
        this.formula2.setColumns(18);
        this.formula2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionPanel.this.formula2_actionPerformed(e);
            }
        });
        this.formula2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionPanel.this.formula2_actionPerformed(e);
            }
        });
        this.formula2.setColumns(18);
        this.formula2.setFont(new Font("SansSerif", 1, 16));
        this.formula2.setVisible(false);
        this.panel.setLayout(this.borderLayout2);
        this.tmax.setToolTipText("");
        this.tmax.setText("1");
        this.tmax.setColumns(4);
        this.tmax.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionPanel.this.update(e);
            }
        });
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("< t <");
        this.tmin.setText("-1");
        this.tmin.setColumns(4);
        this.tmin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionPanel.this.update(e);
            }
        });
        this.range.setLayout(this.gridLayout1);
        this.range.setBorder(this.border1);
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.ybutton, null);
        this.jPanel1.add((Component)this.parametricButton, null);
        this.jPanel1.add((Component)this.polarButton, null);
        this.jPanel1.add(this.implicitButton);
        this.add((Component)this.panel, "Center");
        this.panel.add((Component)this.box, "South");
        this.box.add((Component)this.formula1, null);
        this.box.add(this.component1, null);
        this.box.add((Component)this.formula2, null);
        this.box.add((Component)this.range, null);
        this.range.add((Component)this.tmin, null);
        this.range.add((Component)this.jLabel1, null);
        this.range.add((Component)this.tmax, null);
    }

    public Expression getExpression() {
        if (this.polarButton.isSelected()) {
            PolarExpression e = new PolarExpression(this.formula1.getText());
            e.tMinimum = this.tmin.getText();
            e.tMaximum = this.tmax.getText();
            return e;
        }
        if (this.parametricButton.isSelected()) {
            ParametricExpression e = new ParametricExpression(this.formula1.getText(), this.formula2.getText());
            e.tMinimum = this.tmin.getText();
            e.tMaximum = this.tmax.getText();
            return e;
        }
        if (this.implicitButton.isSelected()) {
            return new ImplicitExpression(this.formula1.getText());
        }
        return new Expression(this.formula1.getText());
    }

    public void setExpression(String s) {
        String params = null;
        String min = "-PI";
        String max = "PI";
        if (s.startsWith("r=")) {
            int q = s.indexOf(59);
            if (q >= 0) {
                params = s.substring(q + 1);
                s = s.substring(0, q);
                int q2 = params.indexOf(59);
                min = params.substring(0, q2);
                max = params.substring(q2 + 1);
            }
            this.polarButton.setSelected(true);
            this.formula1.setText(s.substring(2));
            this.tmin.setText(min);
            this.tmax.setText(max);
        } else if (s.startsWith("y=")) {
            this.ybutton.setSelected(true);
            this.formula1.setText(s.substring(2));
        } else if (s.startsWith("x=")) {
            int q = s.indexOf(59);
            if (q >= 0) {
                String ys = s.substring(q + 1);
                s = s.substring(0, q);
                q = ys.indexOf(59);
                if (q >= 0) {
                    params = ys.substring(q + 1);
                    ys = ys.substring(0, q);
                    int q2 = params.indexOf(59);
                    if (q2 > 0) {
                        min = params.substring(0, q2);
                        max = params.substring(q2 + 1);
                    }
                }
                this.parametricButton.setSelected(true);
                this.formula1.setText(s.substring(2));
                this.formula2.setText(ys.substring(2));
                this.tmax.setText(max);
                this.tmin.setText(min);
            }
        } else if (s.startsWith("0=")) {
            this.implicitButton.setSelected(true);
            this.formula1.setText(s.substring(2));
        }
        this.updateFormula();
    }

    public void setExpression(Expression e) {
        if (e instanceof PolarExpression) {
            this.polarButton.setSelected(true);
            this.formula1.setText(e.getDefinition());
            this.formula2.setVisible(false);
            this.range.setVisible(true);
            this.tmin.setText(((PolarExpression)e).tMinimum);
            this.tmax.setText(((PolarExpression)e).tMaximum);
        } else if (e instanceof ParametricExpression) {
            this.parametricButton.setSelected(true);
            ParametricExpression pe = (ParametricExpression)e;
            this.formula1.setText(pe.getXDefinition());
            this.formula2.setText(pe.getYDefinition());
            this.formula2.setVisible(true);
            this.range.setVisible(true);
            this.tmin.setText(((ParametricExpression)e).tMinimum);
            this.tmax.setText(((ParametricExpression)e).tMaximum);
        } else if (e instanceof ImplicitExpression) {
            this.implicitButton.setSelected(true);
            ImplicitExpression ie = (ImplicitExpression)e;
            this.formula1.setText(e.getDefinition());
            this.formula2.setVisible(false);
        } else {
            this.ybutton.setSelected(true);
            this.formula1.setText(e.getDefinition());
            this.formula2.setVisible(false);
        }
        this.invalidate();
    }

    void formula2_actionPerformed(ActionEvent e) {
        this.updateFormula();
    }

    void formula1_actionPerformed(ActionEvent e) {
        this.updateFormula();
    }

    void radio(ActionEvent e) {
        if (this.parametricButton.isSelected()) {
            this.formula2.setVisible(true);
        } else {
            this.formula2.setVisible(false);
        }
        if (this.ybutton.isSelected() || this.implicitButton.isSelected()) {
            this.range.setVisible(false);
        } else {
            this.range.setVisible(true);
        }
        this.validateTree();
        if (this.parametricButton.isSelected() && this.formula2.getText().equals("")) {
            return;
        }
        this.updateFormula();
    }

    void updateFormula() {
        if (this.al != null) {
            this.al.actionPerformed(new ActionEvent(this, 0, "Update"));
        }
    }

    public void addActionListener(ActionListener al2) {
        this.al = AWTEventMulticaster.add(this.al, al2);
    }

    public void removeActionListener(ActionListener al2) {
        this.al = AWTEventMulticaster.remove(al2, this.al);
    }

    void update(ActionEvent e) {
        this.updateFormula();
    }

    public static String expressionToString(Expression x) {
        if (x instanceof PolarExpression) {
            return "r = " + x.getDefinition();
        }
        if (x instanceof ParametricExpression) {
            return "x = " + ((ParametricExpression)x).getXDefinition() + "; " + ((ParametricExpression)x).getYDefinition();
        }
        if (x instanceof ImplicitExpression) {
            return "0=" + x.getDefinition();
        }
        return "y = " + x.getDefinition();
    }

    public static Expression stringToExpression(String s) {
        s = s.trim();
        Expression e = null;
        if (s.startsWith("y")) {
            if ((s = s.substring(1).trim()).startsWith("=")) {
                s = s.substring(1).trim();
                String[] s2 = s.split(";");
                e = new Expression(s2[0]);
                ExpressionPanel.writeVariables(s2, 1);
            }
        } else if (s.startsWith("r")) {
            if ((s = s.substring(1).trim()).startsWith("=")) {
                s = s.substring(1).trim();
                String[] s2 = s.split(";");
                e = new PolarExpression(s2[0]);
                ExpressionPanel.writeVariables(s2, 1);
            }
        } else if (s.startsWith("x")) {
            if ((s = s.substring(1).trim()).startsWith("=")) {
                s = s.substring(1).trim();
                String[] s2 = s.split(";");
                String xs = s2[0].trim();
                s = s2[1].trim();
                if (s.startsWith("x") && (s = s.substring(1).trim()).startsWith("=")) {
                    String ys = s = s.substring(1).trim();
                    e = new ParametricExpression(xs, ys);
                    ExpressionPanel.writeVariables(s2, 2);
                }
            }
        } else if (s.startsWith("0") && (s = s.substring(1).trim()).startsWith("=")) {
            s = s.substring(1).trim();
            String[] s2 = s.split(";");
            e = new ImplicitExpression(s2[0]);
            ExpressionPanel.writeVariables(s2, 1);
        }
        return e;
    }

    private static void writeVariables(String[] s, int idx) {
    }
}

