/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;

public class DraggableComponent
extends JComponent {
    protected boolean selected;
    protected String name;
    int sx;
    int sy;

    public void setSelected(boolean s) {
        this.selected = s;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DraggableComponent() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                DraggableComponent.this.sx = e.getX();
                DraggableComponent.this.sy = e.getY();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                DraggableComponent.this.dragTo(new Point(DraggableComponent.this.getX() + e.getX() - DraggableComponent.this.sx, DraggableComponent.this.getY() + e.getY() - DraggableComponent.this.sy));
            }
        });
    }

    public void dragTo(Point p) {
        if (this.getParent().contains(p) && this.getParent().contains(p.x + this.getSize().width, p.y + this.getSize().height)) {
            this.setLocation(p);
        } else {
            Container c = this.getParent();
            if (p.x < 0) {
                p.x = 0;
            }
            if (p.x > c.getWidth()) {
                p.x = c.getWidth();
            }
            if (p.y < 0) {
                p.y = 0;
            }
            if (p.y > c.getHeight()) {
                p.y = c.getHeight();
            }
            this.setLocation(p);
        }
    }
}

