/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;

public class CustomSound {
    private byte[] pBuffer;
    private int length;
    private Clip clp;
    private Mixer mix;
    private boolean silent = false;
    int loops = 1;

    public CustomSound(byte[] p) {
        this.open(p);
    }

    public void open(byte[] p) {
        this.pBuffer = new byte[this.loops * p.length];
        int i = 0;
        while (i < p.length) {
            byte value = (byte)(p[i] - 192);
            int j = 0;
            while (j < this.loops) {
                this.pBuffer[j * p.length + i] = value;
                ++j;
            }
            ++i;
        }
        this.length = this.pBuffer.length;
        this.mix = AudioSystem.getMixer(AudioSystem.getMixerInfo()[0]);
        try {
            this.clp = (Clip)this.mix.getLine(this.mix.getSourceLineInfo(new Line.Info(Class.forName("javax.sound.sampled.Clip")))[0]);
            AudioFormat af = new AudioFormat(22050.0f, 16, 1, false, false);
            this.clp.open(af, this.pBuffer, 0, this.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.silent = true;
        }
        FloatControl gain = (FloatControl)this.clp.getControl(FloatControl.Type.MASTER_GAIN);
        gain.setValue(gain.getMaximum() / 8.0f);
    }

    public void close() {
        if (this.clp != null) {
            if (this.isActive()) {
                this.stop();
            }
            if (this.clp.isOpen()) {
                this.clp.close();
            }
        }
    }

    public void start() {
        if (!this.silent) {
            this.clp.loop(-1);
        }
    }

    public void playOnce() {
        if (!this.silent) {
            this.clp.loop(1);
        }
    }

    public void stop() {
        if (!this.silent) {
            this.clp.stop();
            this.clp.setFramePosition(0);
        }
    }

    public boolean isActive() {
        if (!this.silent) {
            return this.clp.isActive();
        }
        return false;
    }

    public void finalize() throws Throwable {
        if (!this.silent) {
            this.clp.close();
        }
        super.finalize();
    }
}

