/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import com.cudos.common.CudosApplet;
import com.cudos.common.CudosExhibit;
import com.cudos.common.TestableExhibit;
import com.cudos.server.client.ClientHandle;
import com.cudos.server.client.LogonDialog;
import com.cudos.server.client.TestResult;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class CudosTest {
    static final String instructions = "Select what corresponds to the highlighted item:";
    static final String correctmessage = "Correct!";
    static final String incorrectmessage = "Incorrect.";
    static final String tryagainmessage = "Try again";
    static final String showcorrectmessage = "This is the correct answer";
    public static final String correctsound = "resources/sounds/CorrectSound.wav";
    public static final String incorrectsound = "resources/sounds/IncorrectSound.wav";
    final int delayCorrect = 3000;
    final int delayIncorrect = 1000;
    TestableExhibit e;
    int testControl;
    int item;
    public int nCorrect;
    public int nTotal;
    int MAX_WRONG_PER_QUESTION = 3;
    int errors;
    Color col1 = Color.red;
    Color col2 = Color.green;
    CudosApplet applet;
    int[] order;
    int lastsel;
    boolean answer;
    Timer timerRestart = new Timer(3000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            CudosTest.this.timerRestart.stop();
            CudosTest.this.newQuestion();
        }
    });
    Timer timerIncorrect = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            CudosTest.this.firedIncorrect();
        }
    });

    public CudosTest(TestableExhibit t) {
        this.e = t;
        this.testControl = 1;
        this.nCorrect = 0;
        this.nTotal = 0;
        this.timerRestart.setDelay(1);
        this.timerRestart.restart();
        this.applet = t.getApplet();
        this.order = CudosTest.randomizeOrder(this.e.getTestItemCount());
    }

    public void instruct() {
        this.e.getTextPane().setText(instructions);
    }

    public void newQuestion() {
        if (this.nTotal == this.e.getTestItemCount()) {
            this.endTest();
            return;
        }
        this.instruct();
        this.item = this.order[this.nTotal++];
        int c = 0;
        while (c < this.e.getTestItemCount()) {
            this.e.clearTestControl(c);
            ++c;
        }
        this.answer = false;
        this.e.selectTestItem(this.testControl, this.item, this.col2);
        this.errors = 0;
        this.lastsel = -1;
    }

    public void judge(int control, int sel) {
        if (this.answer) {
            this.answer = false;
            return;
        }
        if (sel == this.lastsel) {
            return;
        }
        this.lastsel = sel;
        if (this.timerRestart.isRunning()) {
            return;
        }
        if (this.timerIncorrect.isRunning()) {
            this.firedIncorrect();
        }
        if (control != this.testControl) {
            if (sel == this.item) {
                this.e.getTextPane().setText(correctmessage);
                ++this.nCorrect;
                int c = 0;
                while (c < this.e.getTestControlCount()) {
                    this.e.selectTestItem(c, sel, this.col1);
                    ++c;
                }
                this.applet.play(this.applet.getResourceURL(correctsound));
                this.timerRestart.setDelay(3000);
                this.timerRestart.start();
            } else {
                this.e.getTextPane().setText(incorrectmessage);
                this.e.selectTestItem(control, sel, this.col1);
                this.e.selectTestItem(this.testControl, sel, this.col1);
                this.applet.play(this.applet.getResourceURL(incorrectsound));
                this.timerIncorrect.setDelay(1000);
                this.timerIncorrect.start();
            }
        } else {
            this.instruct();
            if (sel != this.item) {
                this.e.selectTestItem(this.testControl, this.item, this.col2);
            }
        }
    }

    public void firedIncorrect() {
        this.timerIncorrect.stop();
        int c = 0;
        while (c < this.e.getTestItemCount()) {
            this.e.clearTestControl(c);
            ++c;
        }
        this.e.getTextPane().setText(tryagainmessage);
        this.e.selectTestItem(this.testControl, this.item, this.col2);
        this.lastsel = -1;
        if (++this.errors >= this.MAX_WRONG_PER_QUESTION) {
            this.answer = true;
            c = 0;
            while (c < this.e.getTestControlCount()) {
                this.e.selectTestItem(c, this.item, this.col1);
                ++c;
            }
            this.e.getTextPane().setText(showcorrectmessage);
            this.timerRestart.start();
        }
    }

    void endTest() {
        int r = JOptionPane.showConfirmDialog(null, "Well done, you have scored " + this.nCorrect + " out of " + this.nTotal + ".\nWould you like to log in and store your result?", "Test complete", 0, 1);
        if (r == 0) {
            LogonDialog d = new LogonDialog();
            d.show();
            ClientHandle h = d.getHandle();
            if (h != null) {
                d.getServer().addTestResult(h, new TestResult(this.e.getTestName(), this.nCorrect, this.nTotal, new Date(System.currentTimeMillis())));
                d.getServer().logout(h);
                JOptionPane.showMessageDialog(null, "Your test result has been stored.", "Result stored", 1);
            } else {
                JOptionPane.showMessageDialog(null, "Your test result has not been stored.", "Result not stored", 2);
            }
        }
    }

    public static final void endTest(String testName, int nCorrect, int nTotal) {
        int r = JOptionPane.showConfirmDialog(null, "Well done, you have scored " + nCorrect + " out of " + nTotal + ".\nWould you like to log in and store your result?", "Test complete", 0, 1);
        if (r == 0) {
            LogonDialog d = new LogonDialog();
            d.show();
            ClientHandle h = d.getHandle();
            if (h != null) {
                d.getServer().addTestResult(h, new TestResult(testName, nCorrect, nTotal, new Date(System.currentTimeMillis())));
                d.getServer().logout(h);
                JOptionPane.showMessageDialog(null, "Your test result has been stored.", "Result stored", 1);
            } else {
                JOptionPane.showMessageDialog(null, "Your test result has not been stored.", "Result not stored", 2);
            }
        }
    }

    public static int[] randomizeOrder(int n) {
        Vector<Integer> v = new Vector<Integer>();
        int i = 0;
        while (i < n) {
            v.add(new Integer(i));
            ++i;
        }
        Collections.shuffle(v);
        int[] a = new int[n];
        int i2 = 0;
        while (i2 < n) {
            a[i2] = (Integer)v.get(i2);
            ++i2;
        }
        return a;
    }

    public static void showCorrectMessage(String information, Component c, boolean message) {
        CudosApplet applet = CudosExhibit.getApplet(c);
        applet.play(applet.getResourceURL(correctsound));
        if (message) {
            JOptionPane.showMessageDialog(c, "Correct!\n" + information, "Correct answer", 1);
        }
    }

    public static void showIncorrectMessage(String information, Component c, boolean message) {
        CudosApplet applet = CudosExhibit.getApplet(c);
        applet.play(applet.getResourceURL(incorrectsound));
        if (message) {
            JOptionPane.showMessageDialog(c, "Incorrect.\n" + information, "Wrong answer", 1);
        }
    }
}

