/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class CudosIndexReader {
    BufferedReader b;
    URL url;

    public CudosIndexReader(URL base, String f) {
        try {
            this.url = new URL(base, f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CudosIndexReader(URL item) {
        this.url = item;
    }

    public String[] getStringsInSection(String section) {
        boolean found = false;
        int count = 0;
        this.reopen();
        try {
            String curr;
            while (this.b.ready()) {
                curr = this.readLine(this.b);
                if (found) {
                    if (curr.startsWith("[")) break;
                    if (curr.length() > 0) {
                        ++count;
                    }
                }
                if (!curr.startsWith("[" + section + "]")) continue;
                found = true;
                this.b.mark(1000);
            }
            if (found) {
                this.b.reset();
                String[] txts = new String[count];
                int i = 0;
                while (i < count) {
                    while ((curr = this.readLine(this.b)).length() == 0) {
                    }
                    txts[i] = curr;
                    ++i;
                }
                return txts;
            }
            throw new RuntimeException("Index section " + section + " not found");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map getMapFromSection(String section) {
        String[] s = this.getStringsInSection(section);
        HashMap<String, String> m = new HashMap<String, String>();
        int i = 0;
        while (i < s.length) {
            int q = s[i].indexOf("=");
            if (q > 0) {
                String l = s[i].substring(0, q).trim();
                String r = s[i].substring(q + 1).trim();
                m.put(l, r);
            } else if (s[i].trim().length() > 0) {
                m.put(s[i], null);
            }
            ++i;
        }
        return m;
    }

    public String getProperty(String section, String property) {
        return (String)this.getMapFromSection(section).get(property);
    }

    public String[] getStringList(String section, String property) {
        String s = (String)this.getMapFromSection(section).get(property);
        if (s.indexOf(44) >= 0) {
            return s.split("\\s*,\\s*");
        }
        return new String[]{s};
    }

    public void reopen() {
        try {
            if (this.b != null) {
                this.b.close();
            }
            InputStream is = this.url.openStream();
            InputStreamReader d = new InputStreamReader(is);
            this.b = new BufferedReader(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getSectionNames() {
        String curr = "";
        int count = 0;
        try {
            this.reopen();
            this.b.mark(50000);
            while (this.b.ready()) {
                curr = this.readLine(this.b);
                if (!curr.startsWith("[") || curr.startsWith("[End]") || curr.startsWith("[Properties]")) continue;
                ++count;
            }
            this.b.reset();
            String[] sect = new String[count];
            int i = 0;
            while (i < count) {
                while (this.b.ready() && (!(curr = this.readLine(this.b)).startsWith("[") || curr.startsWith("[Properties]"))) {
                }
                sect[i] = curr.substring(1, curr.length() - 1).trim();
                ++i;
            }
            return sect;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getProperty(String key) {
        String[] prop = this.getStringsInSection("Properties");
        int i = 0;
        while (i < prop.length) {
            if (prop[i].startsWith(String.valueOf(key) + "=")) {
                return prop[i].substring(key.length() + 1);
            }
            ++i;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLine(BufferedReader b) {
        try {
            String s;
            do {
                if ((s = b.readLine().trim()) != null) continue;
                return null;
            } while (b.ready() && (s.startsWith("//") || s.startsWith(";")));
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

