/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.circuit;

import com.cudos.circuit.CircuitComponent;
import com.cudos.circuit.Circuitboard;
import com.cudos.common.CudosExhibit;
import com.cudos.common.GraphableComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class Voltmeter
extends CircuitComponent
implements GraphableComponent {
    static int sid = 0;
    int id;
    double maxDeflection = 5.0;
    double maxAngle = 1.1938052083641213;
    JTextField tvoltage = new JTextField();
    JLabel meter = new JLabel(){

        public void paint(Graphics g_) {
            super.paint(g_);
            Graphics2D g = (Graphics2D)g_;
            g.setColor(Color.black);
            int r = Voltmeter.this.meter.getHeight();
            int mid = Voltmeter.this.meter.getWidth() / 2;
            double angle = Voltmeter.this.maxAngle * Voltmeter.this.voltage / Voltmeter.this.maxDeflection;
            if (Double.isNaN(angle)) {
                angle = 0.0;
            }
            if (angle > Voltmeter.this.maxAngle) {
                angle = Voltmeter.this.maxAngle;
            } else if (angle < -Voltmeter.this.maxAngle) {
                angle = -Voltmeter.this.maxAngle;
            }
            g.drawLine(mid, r, mid + (int)((double)r * Math.sin(angle)), (int)((double)r * (1.0 - Math.cos(angle))));
            g.drawString(Voltmeter.this.unitString(-Voltmeter.this.maxDeflection), 15, 75);
            g.drawString(Voltmeter.this.unitString(Voltmeter.this.maxDeflection), this.getWidth() - CudosExhibit.getApplet(this).getTextWidth(g, Voltmeter.this.unitString(Voltmeter.this.maxDeflection)) - 15, 75);
            g.drawString(Voltmeter.this.unitString(0.0), (this.getWidth() - CudosExhibit.getApplet(this).getTextWidth(g, Voltmeter.this.unitString(0.0))) / 2, 24);
        }
    };
    double voltage = Double.NaN;
    JLabel graphcolour = new JLabel();
    Border border1;

    public Voltmeter(Circuitboard c) {
        super(c);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.id = sid++;
        this.cname.setText("Voltmeter" + this.id);
        this.i = CudosExhibit.getApplet(this.getCircuitboard()).getImage("resources/icons/Voltmeter.gif");
    }

    String getUnit() {
        return "V";
    }

    public double getResistance() {
        return 1000000.0;
    }

    public void process() {
        double r;
        double l = this.cb.rail[this.c1].voltage;
        this.voltage = l != Double.NaN && (r = this.cb.rail[this.c2].voltage) != Double.NaN ? r - l : Double.NaN;
        this.tvoltage.setText(this.unitString(this.voltage));
        this.repaint();
    }

    public boolean passesCurrent() {
        return false;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
        this.tvoltage.setPreferredSize(new Dimension(80, 21));
        this.tvoltage.setText("0 V");
        this.meter.setPreferredSize(new Dimension(200, 107));
        this.meter.setIcon(new ImageIcon(CudosExhibit.getApplet(this.getCircuitboard()).getImage("resources/icons/Meter.gif")));
        this.setPreferredSize(new Dimension(205, 180));
        this.graphcolour.setBorder(this.border1);
        this.graphcolour.setOpaque(true);
        this.graphcolour.setPreferredSize(new Dimension(85, 21));
        this.graphcolour.setHorizontalAlignment(0);
        this.graphcolour.setHorizontalTextPosition(0);
        this.graphcolour.setBackground(Color.black);
        this.graphcolour.setFont(new Font("Dialog", 1, 12));
        this.graphcolour.setForeground(Color.red);
        this.graphcolour.setText("Graph colour");
        this.add((Component)this.meter, null);
        this.add((Component)this.tvoltage, null);
        this.add((Component)this.graphcolour, null);
    }

    public double getGraphableValue() {
        if (Double.isNaN(this.voltage)) {
            return 0.0;
        }
        return this.voltage;
    }

    public double getGraphableMin() {
        return -this.maxDeflection;
    }

    public double getGraphableMax() {
        return this.maxDeflection;
    }

    public void setColour(Color gcol) {
        this.graphcolour.setForeground(gcol);
    }
}

