/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.circuit;

import com.cudos.circuit.CircuitComponent;
import com.cudos.circuit.Circuitboard;
import com.cudos.common.CudosExhibit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Resistor
extends CircuitComponent {
    static int sid = 0;
    int id;
    JLabel jLabel1 = new JLabel();
    JTextField tresistance = new JTextField();
    JSlider sresistance = new JSlider();
    double resistance;
    Border border1;

    public Resistor(Circuitboard cb) {
        super(cb);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.id = sid++;
        this.cname.setText("Resistor" + this.id);
        this.i = CudosExhibit.getApplet(this.getCircuitboard()).getImage("resources/icons/Resistor.gif");
        this.sresistance.setValue(30);
    }

    String getUnit() {
        return "Ohm";
    }

    public double getResistance() {
        return this.resistance;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(SystemColor.control, 1);
        this.jLabel1.setLabelFor(this.tresistance);
        this.jLabel1.setText("Resistance");
        this.tresistance.setPreferredSize(new Dimension(85, 21));
        this.tresistance.setText("100");
        this.setPreferredSize(new Dimension(195, 120));
        this.sresistance.setValue(10);
        this.sresistance.setMaximum(60);
        this.sresistance.setMajorTickSpacing(10);
        this.sresistance.setPaintTicks(true);
        this.sresistance.setPreferredSize(new Dimension(180, 51));
        this.sresistance.setBorder(this.border1);
        this.sresistance.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Resistor.this.sresistance_stateChanged(e);
            }
        });
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.tresistance, null);
        this.add((Component)this.sresistance, null);
    }

    void sresistance_stateChanged(ChangeEvent e) {
        int v = this.sresistance.getValue();
        this.resistance = v == 0 ? 1.0E-4 : Math.pow(10.0, v / 10) * (double)(1 + v % 10);
        this.tresistance.setText(this.unitString(this.resistance));
    }

    public void setResistance(double resistance) {
        this.resistance = resistance;
    }
}

