/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.circuit;

import com.cudos.circuit.CircuitComponent;
import com.cudos.circuit.Circuitboard;
import com.cudos.common.CudosExhibit;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Lamp
extends CircuitComponent {
    JLabel jLabel1 = new JLabel();
    JTextField tpower = new JTextField();
    static int sid = 0;
    int id;
    double resistance = 100.0;
    double power = 0.0;
    int pcolour;
    double maxWatts = 0.05;

    public Lamp(Circuitboard c) {
        super(c);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.id = sid++;
        this.cname.setText("Lamp" + this.id);
        this.i = CudosExhibit.getApplet(this.getCircuitboard()).getImage("resources/icons/Lamp.gif");
    }

    public void paintCircuit(Graphics g_) {
        super.paintCircuit(g_);
        if (this.pcolour >= 0) {
            int mid = (this.p1.x + this.p2.x) / 2;
            int dw = (this.c1 < this.c2 ? 1 : -1) * this.i.getWidth(this) / 2;
            int dh = this.i.getHeight(this) / 2;
            Graphics2D g = (Graphics2D)g_;
            g.setColor(new Color(this.pcolour, this.pcolour, 0));
            g.setStroke(new BasicStroke(3.0f));
            g.fillOval(mid - Math.abs(dw) / 2, this.p1.y - dh / 2, dw, dh);
        }
    }

    public double getResistance() {
        return this.resistance;
    }

    public String getUnit() {
        return "W";
    }

    public void process() {
        this.power = this.current * this.current * this.resistance;
        this.tpower.setText(this.unitString(this.power));
        int opcolour = this.pcolour;
        this.pcolour = this.powerfn(this.power);
        if (this.pcolour != opcolour) {
            this.cb.repaintCircuitComponent(this);
        }
    }

    int powerfn(double b) {
        if (Double.isNaN(b)) {
            return -1;
        }
        int q = (int)(255.0 * b / this.maxWatts);
        return q < 0 ? 0 : (q > 255 ? 255 : q);
    }

    private void jbInit() throws Exception {
        this.jLabel1.setText("Brightness");
        this.tpower.setPreferredSize(new Dimension(75, 21));
        this.tpower.setText("0 W");
        this.setPreferredSize(new Dimension(160, 70));
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.tpower, null);
    }
}

