/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.circuit;

import com.cudos.circuit.CircuitComponent;
import com.cudos.circuit.CircuitRail;
import com.cudos.common.CudosExhibit;
import com.cudos.common.Matrix;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

public class Circuitboard
extends JPanel {
    public int sx = 32;
    public int sy = 32;
    public int cw = 10;
    public int ch = 10;
    public double deltat = 1.0E-4;
    Rectangle nodesrect = new Rectangle(this.cw, this.ch);
    Image cbimage = null;
    Vector components = new Vector();
    CircuitComponent selection;
    public CircuitRail[] rail = new CircuitRail[this.cw];
    boolean[] traversed;
    Vector pathlist = new Vector();

    public void addCircuitComponent(CircuitComponent cc) {
        this.components.add(cc);
        this.repaint();
    }

    public void removeCircuitComponent(CircuitComponent cc) {
        this.components.remove(cc);
        this.repaint();
    }

    public void removeAllCircuitComponents() {
        this.components.removeAllElements();
        this.repaint();
    }

    public void init() {
        this.cbimage = CudosExhibit.getApplet(this).getImage("resources/icons/Circuitboard.jpg");
        int i = 0;
        while (i < this.cw) {
            this.rail[i] = new CircuitRail(this, i);
            ++i;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.cbimage != null) {
            int i = 0;
            while (i < this.cw) {
                int j = 0;
                while (j < this.ch) {
                    g.drawImage(this.cbimage, this.sx * i, this.sy * j, this);
                    ++j;
                }
                ++i;
            }
        }
        g.translate(this.sx / 2 + 3, this.sy / 2 + 3);
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            CircuitComponent c = (CircuitComponent)e.nextElement();
            c.paintCircuit(g);
        }
    }

    public void repaintCircuitComponent(CircuitComponent cc) {
        Graphics g = this.getGraphics();
        if (this.cbimage != null) {
            int s2;
            int s1;
            if (cc.c2 > cc.c1) {
                s1 = cc.c1;
                s2 = cc.c2;
            } else {
                s1 = cc.c2;
                s2 = cc.c1;
            }
            int i = s1;
            while (i <= s2) {
                g.drawImage(this.cbimage, this.sx * i, this.sy * cc.ch, this);
                ++i;
            }
        }
        g.translate(this.sx / 2 + 3, this.sy / 2 + 3);
        cc.paintCircuit(g);
    }

    public Point getNearestNode(Point p) {
        Point np = new Point(p.x / this.sx, p.y / this.sy);
        if (this.nodesrect.contains(np)) {
            return np;
        }
        return null;
    }

    public Point getExactNode(Point p) {
        Point np = this.getNearestNode(p);
        if (np != null && Math.abs(np.x * this.sx + this.sx / 2 - p.x) < 7 && Math.abs(np.y * this.sy + this.sy / 2 - p.y) < 7) {
            return np;
        }
        return null;
    }

    public CircuitComponent getComponent(Point p) {
        Point np = this.getNearestNode(p);
        if (np == null) {
            return null;
        }
        CircuitComponent nc = null;
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            CircuitComponent c = (CircuitComponent)e.nextElement();
            if (c.ch != np.y || (c.c1 < np.x || c.c2 > np.x) && (c.c2 < np.x || c.c1 > np.x)) continue;
            nc = c;
        }
        return nc;
    }

    public CircuitComponent getComponentAtNode(Point np) {
        CircuitComponent nc = null;
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            CircuitComponent c = (CircuitComponent)e.nextElement();
            if (c.ch != np.y || c.c1 != np.x && c.c2 != np.x) continue;
            nc = c;
        }
        return nc;
    }

    public boolean isOpen(Point cp) {
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            CircuitComponent c = (CircuitComponent)e.nextElement();
            if (c.ch != cp.y || (c.c1 < cp.x || c.c2 > cp.x) && (c.c1 > cp.x || c.c2 < cp.x)) continue;
            return false;
        }
        return true;
    }

    public boolean isLineClear(int l, int r, int h, CircuitComponent exclude) {
        if (l > r) {
            int t = l;
            l = r;
            r = t;
        }
        if (!this.nodesrect.contains(l, h) || !this.nodesrect.contains(r, h)) {
            return false;
        }
        int cx = l;
        while (cx <= r) {
            Enumeration e = this.components.elements();
            while (e.hasMoreElements()) {
                CircuitComponent c = (CircuitComponent)e.nextElement();
                if (c == exclude || c.ch != h || (c.c1 < cx || c.c2 > cx) && (c.c1 > cx || c.c2 < cx)) continue;
                return false;
            }
            ++cx;
        }
        return true;
    }

    public Vector getByBehaviour(Vector v, int b) {
        Vector r = new Vector();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (((CircuitComponent)o).getBehaviour() != b) continue;
            r.add(o);
        }
        return r;
    }

    public void startCalculation() {
        CircuitComponent cc;
        this.traversed = new boolean[this.components.size()];
        int i = 0;
        while (i < this.traversed.length) {
            this.traversed[i] = false;
            ((CircuitComponent)this.components.get((int)i)).current = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.rail.length) {
            this.rail[i].voltage = Double.NaN;
            ++i;
        }
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            CircuitComponent cc2 = (CircuitComponent)e.nextElement();
            cc2.paths.removeAllElements();
            cc2.directions.removeAllElements();
        }
        this.pathlist.removeAllElements();
        Vector emfc = this.getByBehaviour(this.components, 3);
        Enumeration e2 = emfc.elements();
        while (e2.hasMoreElements()) {
            cc = (CircuitComponent)e2.nextElement();
            if (this.traversed[this.components.indexOf(cc)]) continue;
            this.rail[cc.c1].voltage = 0.0;
            TraceStatus stat = new TraceStatus();
            int sz = this.pathlist.size();
            stat = this.traceCircuit(cc, cc.c1, stat);
            if (this.pathlist.size() != sz || !Double.isNaN(this.rail[cc.c2].voltage)) continue;
            this.rail[cc.c2].voltage = cc.getEMF();
        }
        this.doEliminateOpenPaths();
        this.doPathCurrentCalculation();
        this.doVoltageCalculation();
        e2 = this.components.elements();
        while (e2.hasMoreElements()) {
            cc = (CircuitComponent)e2.nextElement();
            cc.process();
        }
    }

    public TraceStatus traceCircuit(CircuitComponent c, int r, TraceStatus s) {
        if (r == c.c2) {
            CircuitPath cp = new CircuitPath();
            cp.cstart = c;
            cp.emf = s.emf + c.getEMF();
            this.pathlist.add(cp);
            Enumeration e = s.ccrossed.elements();
            while (e.hasMoreElements()) {
                CircuitComponent cc = (CircuitComponent)e.nextElement();
                cp.components.add(cc);
                cc.paths.add(cp);
                Boolean d = (Boolean)s.directions.get(s.ccrossed.indexOf(cc));
                cp.directions.add(d);
                cc.directions.add(d);
                this.traversed[this.components.indexOf((Object)cc)] = true;
            }
            return null;
        }
        s.rcrossed[r] = true;
        Vector nextc = this.rail[r].getComponentsOnRail();
        Enumeration e = nextc.elements();
        while (e.hasMoreElements()) {
            int dr;
            CircuitComponent cc = (CircuitComponent)e.nextElement();
            if (cc == c || !cc.passesCurrent() || s.rcrossed[dr = this.getDestRail(cc, r)]) continue;
            TraceStatus n = (TraceStatus)s.clone();
            n.emf = n.emf - (double)(r == cc.c1 ? 1 : -1) * cc.getEMF();
            n.ccrossed.add(cc);
            n.directions.add(new Boolean(r == cc.c1));
            n = this.traceCircuit(c, dr, n);
        }
        return s;
    }

    public void doEliminateOpenPaths() {
        Vector<CircuitPath> removal = new Vector<CircuitPath>();
        Enumeration e = this.pathlist.elements();
        while (e.hasMoreElements()) {
            CircuitComponent cc;
            CircuitPath cp = (CircuitPath)e.nextElement();
            boolean valid = true;
            Enumeration f = cp.components.elements();
            while (f.hasMoreElements()) {
                boolean dir;
                cc = (CircuitComponent)f.nextElement();
                double res = cc.getResistanceFromEMF(cp.emf * (double)((dir = ((Boolean)cp.directions.get(cp.components.indexOf(cc))).booleanValue()) ? 1 : -1));
                if (!Double.isInfinite(res)) continue;
                valid = false;
            }
            if (valid) continue;
            f = cp.components.elements();
            while (f.hasMoreElements()) {
                cc = (CircuitComponent)f.nextElement();
                int ix = cc.paths.indexOf(cp);
                cc.paths.remove(ix);
                cc.directions.remove(ix);
                this.traversed[this.components.indexOf((Object)cc)] = false;
            }
            removal.add(cp);
        }
        this.pathlist.removeAll(removal);
    }

    public int getDestRail(CircuitComponent c, int r) {
        if (c.c1 == r) {
            return c.c2;
        }
        if (c.c2 == r) {
            return c.c1;
        }
        System.out.println("Bad destination rail from " + r + " on " + c);
        return 0;
    }

    public void doPathCurrentCalculation() {
        int n = this.pathlist.size();
        if (n == 0) {
            return;
        }
        double[][] resistance = new double[n][n];
        Enumeration e = this.pathlist.elements();
        while (e.hasMoreElements()) {
            CircuitPath cp = (CircuitPath)e.nextElement();
            int icp = this.pathlist.indexOf(cp);
            Enumeration f = cp.components.elements();
            while (f.hasMoreElements()) {
                CircuitComponent cc = (CircuitComponent)f.nextElement();
                boolean dir = (Boolean)cp.directions.get(cp.components.indexOf(cc));
                double res = cc.getResistanceFromEMF(cp.emf * (double)(dir ? 1 : -1));
                Enumeration g = cc.paths.elements();
                while (g.hasMoreElements()) {
                    CircuitPath rp = (CircuitPath)g.nextElement();
                    int irp = this.pathlist.indexOf(rp);
                    double[] dArray = resistance[icp];
                    int n2 = irp;
                    dArray[n2] = dArray[n2] + res;
                }
            }
        }
        Matrix m = new Matrix(resistance).inverse();
        if (m != null) {
            double[][] emf = new double[n][1];
            int i = 0;
            while (i < n) {
                emf[i][0] = ((CircuitPath)this.pathlist.get((int)i)).emf;
                ++i;
            }
            Matrix current = m.multiply(new Matrix(emf));
            if (current == null) {
                System.out.println("Error@current calculation");
            } else {
                int i2 = 0;
                while (i2 < n) {
                    CircuitPath cp = (CircuitPath)this.pathlist.get(i2);
                    cp.current = current.a[i2][0];
                    ++i2;
                }
            }
        }
    }

    public void doVoltageCalculation() {
        Enumeration e = this.pathlist.elements();
        while (e.hasMoreElements()) {
            CircuitPath cp = (CircuitPath)e.nextElement();
            int r = cp.cstart.c1;
            double potential = this.rail[r].voltage;
            if (Double.isNaN(potential)) {
                this.rail[r].voltage = 0.0;
                potential = 0.0;
            }
            Enumeration f = cp.components.elements();
            while (f.hasMoreElements()) {
                CircuitComponent cc = (CircuitComponent)f.nextElement();
                int icp = cc.paths.indexOf(cp);
                int dir = (Boolean)cc.directions.get(icp) != false ? 1 : -1;
                cc.current += (double)dir * cp.current;
                r = this.getDestRail(cc, r);
                this.rail[r].voltage = potential += (double)dir * cc.current * cc.getResistanceFromEMF((double)dir * cp.emf) + (double)dir * cc.getEMF();
            }
            cp.cstart.current -= cp.current;
        }
    }

    class CircuitPath {
        CircuitComponent cstart;
        Vector components = new Vector();
        Vector directions = new Vector();
        double current = Double.NaN;
        double emf = 0.0;

        CircuitPath() {
        }
    }

    class TraceStatus
    implements Cloneable {
        double emf = 0.0;
        boolean[] rcrossed;
        Vector ccrossed;
        Vector directions;

        TraceStatus() {
            this.rcrossed = new boolean[Circuitboard.this.cw];
            this.ccrossed = new Vector();
            this.directions = new Vector();
            int i = 0;
            while (i < this.rcrossed.length) {
                this.rcrossed[i] = false;
                ++i;
            }
        }

        public Object clone() {
            try {
                TraceStatus n = (TraceStatus)super.clone();
                n.ccrossed = (Vector)this.ccrossed.clone();
                n.directions = (Vector)this.directions.clone();
                n.rcrossed = (boolean[])this.rcrossed.clone();
                return n;
            }
            catch (Exception x) {
                x.printStackTrace();
                return null;
            }
        }
    }
}

