/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.circuit;

import com.cudos.circuit.Circuitboard;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CircuitComponent
extends JPanel
implements ImageObserver {
    Circuitboard cb;
    protected Image i = null;
    public int ch;
    public int c1;
    public int c2;
    public Point p1;
    public Point p2;
    public boolean selected = false;
    double current;
    JTextField cname = new JTextField();
    JLabel jLabel1 = new JLabel();
    FlowLayout flowLayout1 = new FlowLayout();
    public static final int B_RESISTOR = 1;
    public static final int B_FIXEDVOLTAGE = 2;
    public static final int B_EMF = 3;
    static final String[] prefix = new String[]{"p", "n", "\u00b5", "m", "", "k", "M"};
    static final double[] vunit = new double[]{1.0E-12, 1.0E-9, 1.0E-6, 0.001, 1.0, 1000.0, 1000000.0};
    Vector paths = new Vector();
    Vector directions = new Vector();

    public CircuitComponent() {
        this((Circuitboard)null);
    }

    public CircuitComponent(Circuitboard tcb) {
        this.cb = tcb;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Circuitboard getCircuitboard() {
        return this.cb;
    }

    public void paintCircuit(Graphics g_) {
        Graphics2D g = (Graphics2D)g_;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int mid = (this.p1.x + this.p2.x) / 2;
        int dw = (this.c1 < this.c2 ? 1 : -1) * this.i.getWidth(this) / 2;
        int dh = this.i.getHeight(this) / 2;
        g.setStroke(new BasicStroke(3.0f));
        g.setColor(Color.black);
        g.drawLine(this.p1.x, this.p1.y, mid - dw, this.p1.y);
        g.drawLine(mid + dw, this.p1.y, this.p2.x, this.p1.y);
        g.fillOval(this.p1.x - 4, this.p1.y - 4, 8, 8);
        g.fillOval(this.p2.x - 4, this.p2.y - 4, 8, 8);
        if (this.isReversible()) {
            g.drawImage(this.i, mid - dw, this.p1.y - dh, mid + dw, this.p1.y + dh, 0, 0, this.i.getWidth(this), this.i.getHeight(this), this);
        } else {
            g.drawImage(this.i, mid - Math.abs(dw), this.p1.y - dh, this);
        }
        if (this.selected) {
            g.setColor(Color.red);
            if (this.c1 < this.c2) {
                g.drawRect(this.p1.x, this.p1.y - dh, this.p2.x - this.p1.x, dh * 2);
            } else {
                g.drawRect(this.p2.x, this.p2.y - dh, this.p1.x - this.p2.x, dh * 2);
            }
        }
    }

    public boolean imageUpdate(Image image, int info, int x, int y, int w, int h) {
        return (info & 0x20) <= 0;
    }

    public void onMove() {
        Point np1 = new Point(this.c1 * this.cb.sx, this.ch * this.cb.sy);
        Point np2 = new Point(this.c2 * this.cb.sx, this.ch * this.cb.sy);
        if (this.p1 == null || this.p2 == null || np1.x != this.p1.x || np1.y != this.p1.y || np2.x != this.p2.x || np2.y != this.p2.y) {
            this.p1 = np1;
            this.p2 = np2;
            this.cb.repaint();
        }
    }

    public double getResistanceFromEMF(double emf) {
        return this.getResistance();
    }

    public double getResistance() {
        return 0.001;
    }

    public double getEMF() {
        return 0.0;
    }

    public void process() {
    }

    public boolean passesCurrent() {
        return true;
    }

    public boolean isReversible() {
        return false;
    }

    private void jbInit() throws Exception {
        this.cname.setPreferredSize(new Dimension(100, 21));
        this.cname.setText("Dummy component");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.setPreferredSize(new Dimension(160, 40));
        this.setLayout(this.flowLayout1);
        this.jLabel1.setLabelFor(this.cname);
        this.jLabel1.setText("Name");
        this.flowLayout1.setAlignment(0);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.cname, null);
    }

    public String getName() {
        return this.cname.getText();
    }

    public void setName(String s) {
        this.cname.setText(s);
    }

    public int getBehaviour() {
        return 1;
    }

    String getUnit() {
        return "";
    }

    public String unitString(double v) {
        if (Double.isNaN(v)) {
            return "??? " + this.getUnit();
        }
        boolean neg = v < 0.0;
        v = Math.abs(v);
        double sval = Double.NaN;
        String pf = "tiny";
        int round = 10;
        int i = vunit.length - 1;
        while (i >= 0) {
            if (v >= vunit[i]) {
                sval = v / vunit[i];
                pf = prefix[i];
                break;
            }
            --i;
        }
        if (pf.equals("tiny")) {
            if (v != 0.0) {
                sval = v / vunit[0];
                pf = prefix[0];
                round = 1000;
            } else {
                pf = "";
            }
        }
        return String.valueOf(neg ? "-" : "") + (double)Math.round(sval * (double)round) * 1.0 / (double)round + " " + pf + this.getUnit();
    }
}

