/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.circuit;

import com.cudos.circuit.CircuitComponent;
import com.cudos.circuit.Circuitboard;
import com.cudos.common.CudosExhibit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Cell
extends CircuitComponent {
    JTextField tvoltage = new JTextField();
    static int sid = 0;
    int id;
    JLabel jLabel1 = new JLabel();
    JSlider svoltage = new JSlider();
    Border border1;
    double voltage;

    public Cell(Circuitboard c) {
        super(c);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.id = sid++;
        this.cname.setText("Cell" + this.id);
        this.i = CudosExhibit.getApplet(this.getCircuitboard()).getImage("resources/icons/Cell.gif");
        this.svoltage.setValue(30);
    }

    public double getEMF() {
        return this.voltage;
    }

    public String getUnit() {
        return "V";
    }

    public int getBehaviour() {
        return 3;
    }

    public boolean isReversible() {
        return true;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(SystemColor.control, 1);
        this.tvoltage.setPreferredSize(new Dimension(80, 21));
        this.tvoltage.setText("0");
        this.jLabel1.setText("Voltage");
        this.setPreferredSize(new Dimension(200, 110));
        this.svoltage.setMaximum(50);
        this.svoltage.setMajorTickSpacing(10);
        this.svoltage.setPaintTicks(true);
        this.svoltage.setPreferredSize(new Dimension(180, 32));
        this.svoltage.setBorder(this.border1);
        this.svoltage.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Cell.this.svoltage_stateChanged(e);
            }
        });
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.tvoltage, null);
        this.add((Component)this.svoltage, null);
    }

    public void setVoltage(double v) {
        this.voltage = v;
        this.tvoltage.setText(this.unitString(this.voltage));
    }

    public double getVoltage() {
        return this.voltage;
    }

    void svoltage_stateChanged(ChangeEvent e) {
        int v = this.svoltage.getValue() - 1;
        this.voltage = v == 0 ? 0.0 : 0.001 * Math.pow(10.0, v / 10) * (double)(v % 10 + 1);
        this.tvoltage.setText(this.unitString(this.voltage));
    }
}

